
  <style>
    body {
      font-family: 'Roboto', sans-serif;
    }

    .navbar-custom {
      background-color: #524C4C; /* Üst menü için koyu gri arka plan */
      padding: 0.5rem 2rem; /* Genişliği artırmak için padding artırıldı */
    }

    .navbar-brand img {
      height: 40px; /* Logo boyutu */
    }

    .nav-link {
      font-family: 'Roboto', sans-serif;
      font-weight: bold;
      font-size: 18px;
    }

    .top-navbar {
      background-color: #524C4C;
      color: white;
      padding: 0.5rem 2rem;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .top-navbar .currency-info,
    .top-navbar .location-info,
    .top-navbar .temperature-info {
      color: white;
      font-family: 'Roboto', sans-serif;
      font-weight: 500;
      font-size: 14px;
    }

    .top-navbar .temperature-info img {
      width: 20px;
      height: 20px;
      margin-right: 5px;
    }

    .top-navbar-icons {
      display: flex;
      align-items: center;
      gap: 30px; /* Aralarındaki mesafeyi artırdım */
      justify-content: flex-start; /* Sola dayalı */
      flex: 1; /* Bu öğelerin alanı doldurmasını sağlar */
    }

    .top-navbar-icons a {
      color: #CCCCCC; /* Yazı rengi */
      font-family: 'Roboto', sans-serif;
      font-weight: 600; /* Roboto Semi Bold */
      font-size: 14px;
      text-decoration: none; /* Alt çizgiyi kaldır */
      text-transform: uppercase; /* Büyük harf yapma */
    }

    .top-navbar-icons a:hover {
      color: white !important; /* Hover durumunda beyaz renk */
    }

    /* Mobil Görünüm Ayarları */
    @media (max-width: 768px) {
      .top-navbar-icons {
        display: none; /* Mobilde gizle */
      }

      .navbar-icons {
        display: flex;
        align-items: center;
        gap: 15px;
      }

      .bottom-navbar .navbar-brand {
        order: 1; /* Logo sola taşınacak */
      }

      .navbar-icons {
        margin-left: auto;
        order: 3; /* Menü ve arama ikonu sağda kalacak */
      }
      .nav-item{
        margin-top:10px;
      }


       .bottom-navbar {
      padding: 10px !important; /* Genişliği artırmak için padding artırıldı */
    }
    }


       @media (min-width: 769px) {
  
          .search-icon {
         display: block; 
    }
    }

        .navbar-expand-lg .navbar-nav {
        margin-right: 80px;
    }


    /* Alt Menü Stili */
    .bottom-navbar {
      background-color: #ffffff;
      padding: 0.5rem 2rem; /* Genişliği artırmak için padding artırıldı */
      display: flex;
      align-items: center;
    }

    .bottom-navbar .nav-link {
      color: #524C4C !important; /* Menü yazı rengi */
      font-size: 16px;
    }

    /* Arama ve Menü İkonu Ayarları */
    .navbar-icons {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .search-icon, .menu-icon {
      color: black; /* Siyah arama ikonu */
      font-size: 20px;
    }

    /* Soldan kayan menü için */
    #sidebar {
      position: fixed;
      top: 0;
      left: -250px;
      width: 250px;
      height: 100%;
      background: #524C4C;
      color: white;
      transition: left 0.3s;
      padding: 20px;
      z-index: 9999999999;
    }

    #sidebar.active {
      left: 0;
    }

    #sidebar .navbar-brand img {
      margin-top: 20px;
      height: 40px;
    }
  </style>
<body>
<!-- Üst Bilgilendirme Kısmı -->
<div class="top-navbar">
    <div class="container-fluid container" style="    display: flex;">

  <div class="top-navbar-icons d-none d-lg-flex"> <!-- Bu kısmı webde görünür, mobilde gizli hale getirdim -->
    <a href="/foto-galeri"><i class="bi bi-camera"></i> Foto Galeri</a>
    <a href="/video-galeri"><i class="bi bi-film"></i> Video Galeri</a>
    <a href="/yazarlar"><i class="bi bi-pen"></i> Yazarlar</a>
      <?php if(config('settings.youtube_canli_yayin')!=''): ?>
    <a href="<?php echo e(config('settings.youtube_canli_yayin')); ?>" rel="nofollow" target="_blank"><i class="bi bi-broadcast"></i> Canlı Yayın</a>
     <?php endif; ?>
  </div>
  <div class="d-flex align-items-center">
    <div id="currency-info" class="currency-info me-3">
      USD <span class="price">33.67</span> 
      <span class="change">▲ +0.17</span>
    </div>
    <div class="location-info me-3">
      <?php echo e(config('settings.main_city')); ?>

    </div>
    <div class="temperature-info d-flex align-items-center">
      <img src="https://habercode.enbursa.com/img/Rain.png" alt="Weather Icon"> <?php echo e(config('settings.weather_degree', '')); ?>

    </div>
  </div>
  </div>
</div>

<!-- Orta Kısım Navbar (Logo ve Menü) -->
<nav class="navbar navbar-expand-lg bottom-navbar">
  <div class="container-fluid container" style="    padding-left: 0px;">
    <i id="menu-toggle" class="bi bi-list menu-icon d-lg-none"></i> <!-- Mobilde menü ikonu solda -->
    <a class="navbar-brand d-flex align-items-center ms-2" href="/">
      <img src="/uploads/logo/<?php echo e(config('settings.sayfa_logo', 'Varsayılan Başlık')); ?>" alt="Haber Code Logo">
    </a>
    <div class="collapse navbar-collapse justify-content-center">
      <ul class="navbar-nav mb-2 mb-lg-0">
      <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="nav-item"><a class="nav-link" title="<?php echo e($category->name); ?> - <?php echo e(config('settings.site_title', 'Varsayılan Başlık')); ?>" href="/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
      </ul>
    </div>
    <div class="navbar-icons">
      <i class="bi bi-search search-icon"></i> <!-- Arama ikonu sağda -->
    </div>
  </div>
</nav>

<!-- Soldan kayan menü -->
<div id="sidebar">
  <ul class="list-unstyled">
   <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="nav-item"><a class="nav-link" title="<?php echo e($category->name); ?> - <?php echo e(config('settings.site_title', 'Varsayılan Başlık')); ?>" href="/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
  </ul>
  <a class="navbar-brand" href="#">
    <img src="/uploads/logo/<?php echo e(config('settings.sayfa_logo', 'Varsayılan Başlık')); ?>" alt="Haber Code Logo">
  </a>
</div>
  <div class="breaking-news mt-2">
        <div class="container">
            <div class="d-flex align-items-center">
                <div class="incontainer">
                    <i class="bi bi-clock icon"></i>
                    <div class="headline">SON DAKİKA</div>
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="prev" style="margin-left: 30px;" src="/img/chevron-right-2.png" alt="Son Dakika Haberleri Sola Kaydırma İkonu">
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="next" src="/img/chevron-right-3.png" alt="Son Dakika Haberleri Sağa Kaydırma İkonu">
                </div>
                 <div id="breakingNewsCarousel" class="carousel slide breaking-news" data-bs-ride="carousel"  data-bs-interval="2500" >
                    <div class="carousel-inner">
                    <?php 
                    $i=0;
                    ?>
                    <?php $__currentLoopData = $sondakikahaberler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sondakikahaber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $i++ ?>
                      <div class="carousel-item <?php if($i==1): ?> active <?php endif; ?>" style="cursor:pointer">
                        <div class="time"><?php echo e($sondakikahaber->time); ?></div>
                        <div class="news"><a href="/<?php echo e($sondakikahaber->slug); ?>.html" title="<?php echo e($sondakikahaber->name); ?>"><?php echo e($sondakikahaber->name); ?></a></div>
                     </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                    </div>
            </div>
        </div>
    </div>
<script>
  const currencyInfoElement = document.getElementById('currency-info');
  let index = 0;

  const currencies = [
    { type: 'USD', price: '33.67', change: '▲ +0.17', color: 'white' },
    { type: 'EUR', price: '39.12', change: '▲ +0.12', color: 'white' },
    { type: 'Altın', price: '2000.00', change: '▼ -5.00', color: 'white' }
  ];

  function updateCurrency() {
    index = (index + 1) % currencies.length;
    const currentCurrency = currencies[index];
    currencyInfoElement.innerHTML = `
      ${currentCurrency.type} <span class="price">${currentCurrency.price}</span> 
      <span class="change" style="color: ${currentCurrency.color}">${currentCurrency.change}</span>
    `;
  }

  setInterval(updateCurrency, 10000); // 10 saniyede bir döviz bilgisini değiştir

  // Menü ikonuna tıklayınca soldan kayan menü açılması
  const menuToggle = document.getElementById('menu-toggle');
  const sidebar = document.getElementById('sidebar');
  menuToggle.addEventListener('click', () => {
    sidebar.classList.toggle('active');
  });
</script>
<?php /**PATH /home/kocaeliduysun/public_html/resources/views/layout/menu4.blade.php ENDPATH**/ ?>