
  <style>
    /* Genel Stil Ayarları */
    body {
      font-family: 'Roboto', sans-serif;
    }

    .top-navbar {
      background-color: #ffffff; /* Açık gri arka plan */
      color: black;
      padding: 0.5rem 2rem;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .top-navbar .currency-info {
      font-weight: 700;
      color: #333;
    }

    .top-navbar .currency-info span {
      margin-right: 10px;
    }

    .top-navbar .currency-info .price {
      color: green;
      margin-left: 5px;
    }

    .top-navbar .currency-info .price.red {
      color: red;
    }

    .top-navbar .currency-info i {
      margin-right: 5px;
    }

    .social-media-icons {
      display: flex;
      gap: 10px; /* Daha az boşluk */
    }

    .social-media-icons img {
      height: 20px; /* İkon boyutunu küçülttüm */
    }

    .middle-navbar {
      padding: 0.5rem 2rem;
      padding-left:0px;
      display: flex;
      align-items: center;
      background-color: white;
      border-bottom: 1px solid #ddd;
    }

    .middle-navbar .navbar-brand img {
      height: 40px; /* Logo boyutu daha küçük */
    }

    .bottom-navbar {
      background-color: #524C4C; /* Koyu gri arka plan */
      padding: 0.5rem 2rem;
    }

    .bottom-navbar-icons {
      display: flex;
      gap: 15px; /* Aralarındaki mesafeyi azalttım */
      align-items: center;
    }

    .bottom-navbar-icons a {
      color: #524C4C; /* Yazı rengi koyu gri */
      font-family: 'Roboto', sans-serif;
      font-weight: 600; /* Roboto Semi Bold */
      font-size: 13px; /* Yazı boyutunu küçülttüm */
      text-decoration: none; /* Alt çizgiyi kaldır */
      display: flex;
      align-items: center;
      gap: 5px;
    }

    .bottom-navbar-icons a img {
      height: 18px; /* İkon boyutu daha orantılı */
    }

    .bottom-navbar-icons a:hover {
      color: black; /* Hover durumunda yazı koyu renk */
    }

    .category-navbar {
      background-color: #4A4A4A; /* Daha koyu bir gri */
      padding: 0.5rem 2rem;
    }

    .category-navbar .nav-link {
    color: white !important;
    font-size: 15px;
    font-weight: 600;
    margin-right: 20px;
    line-height: 1.6;
    }

    .menu-icon{
    	display: none;
    }

    .arama-icon{
    	display: none;
    }

    .category-navbar .nav-link:hover {
      color: #FF0000 !important; /* Hover durumunda kırmızı renk */
    }

    /* Mobil Görünüm Ayarları */
    @media (max-width: 768px) {
      .top-navbar {
        display: none; /* Mobilde gizle */
      }

      .category-navbar{
      	display: none;
      }

      .navbar-icons{
      	display: none !important;
      }

      .navbar-icons {
        display: flex;
        align-items: center;
        gap: 15px;
      }

      .bottom-navbar .navbar-brand {
        order: 1; /* Logo sola taşınacak */
      }

      .navbar-icons {
        margin-left: auto;
        order: 3; /* Menü ve arama ikonu sağda kalacak */
      }
      .nav-item{
        margin-top:10px;
      }

       .menu-icon{
    	display: block;
    }

    .arama-icon{
    	display: block;
    }


.navbar-brand {
    width: 100%;
}
       .bottom-navbar {
      padding: 10px !important; /* Genişliği artırmak için padding artırıldı */
    }
    .middle-navbar {
    padding-left: 10px;
}
    }
    /* Soldan kayan menü için */
    #sidebar {
      position: fixed;
      top: 0;
      left: -250px;
      width: 250px;
      height: 100%;
      background: #524C4C;
      color: white;
      transition: left 0.3s;
      padding: 20px;
      z-index: 9999999999;
    }

    #sidebar.active {
      left: 0;
    }

    #sidebar .navbar-brand img {
      margin-top: 20px;
      height: 40px;
    }
       .search-icon, .menu-icon {
      color: black; /* Siyah arama ikonu */
      font-size: 20px;
    }


    hr.custom-hr {
      border: none;
      border-top: 1px solid #C0B2B;
      margin: 0;
    }

    .navbar-icons a{
    	color: #524C4C;
    text-decoration: none;
    font-weight: 600;
    font-size: 15px;
    margin-left: 20px;
    }
  </style>
</head>
<body>

<!-- Üst Bilgilendirme Kısmı -->
<div class="top-navbar container">
  <div class="currency-info">
    <span><i class="bi bi-caret-up-fill text-success"></i> USD <span class="price">33.67</span></span>
    <span><i class="bi bi-caret-down-fill text-danger"></i> EURO <span class="price red">33.67</span></span>
    <span><i class="bi bi-caret-up-fill text-success"></i> ALTIN <span class="price">2563</span></span>
    <span><i class="bi bi-caret-up-fill text-success"></i> BIST <span class="price">6463</span></span>
  </div>
  <div class="social-media-icons">
    <a href="#"><img src="/menuicons/Facebook.png" alt="Facebook"></a>
    <a href="#"><img src="/menuicons/TwitterX.png" alt="TwitterX"></a>
    <a href="#"><img src="/menuicons/Instagram.png" alt="Instagram"></a>
    <a href="#"><img src="/menuicons/LinkedIn.png" alt="LinkedIn"></a>
    <a href="#"><img src="/menuicons/YouTube.png" alt="YouTube"></a>
    <a href="#"><img src="/menuicons/WhatsApp.png" alt="WhatsApp"></a>
  </div>
</div>

<hr class="custom-hr"> <!-- İnce HR çizgisi eklendi -->

<!-- Orta Kısım Navbar (Logo ve Menü) -->
<div class="middle-navbar container">
	        <img src="/menuicons/MenuBlack.png" class="menu-icon" id="menu-toggle" alt="Arama" style="cursor: pointer; height: 25px;">

  <a class="navbar-brand d-flex align-items-center ms-2" href="/">

    <img src="/uploads/logo/<?php echo e(config('settings.sayfa_logo', 'Varsayılan Başlık')); ?>"  alt="Haber Code Logo">

  </a>
          <img src="/menuicons/Search.png" class="arama-icon" alt="Arama" style="cursor: pointer; height: 25px;">

  <div class="navbar-icons ms-auto d-flex gap-3">
    <a href="#"><img src="/menuicons/Camera.png" alt="Foto Galeri" style="height: 20px;"> Foto Galeri</a>
    <a href="#"><img src="/menuicons/VideoCamera.png" alt="Video Galeri" style="height: 20px;"> Video Galeri</a>
     <?php if(config('settings.youtube_canli_yayin')!=''): ?>
    <a href="<?php echo e(config('settings.youtube_canli_yayin')); ?>" rel="nofollow" target="_blank"><img src="/menuicons/BrowsePodcasts.png" alt="Canlı Yayın" style="height: 20px;"> Canlı Yayın</a>
     <?php endif; ?>

    <img src="/menuicons/Search.png" alt="Arama" style="cursor: pointer; height: 25px;">
  </div>
</div>

<!-- Alt Menü (Kategoriler) -->
<nav class="navbar navbar-expand-lg category-navbar">
  <div class="container-fluid justify-content-start container">
    <ul class="navbar-nav mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="#"><img src="/menuicons/home.png" alt="Menu" style="height: 26px;    margin-top: -3px;
"></a></li>
     <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="nav-item"><a class="nav-link" title="<?php echo e($category->name); ?> - <?php echo e(config('settings.site_title', 'Varsayılan Başlık')); ?>" href="/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
  </div>
</nav>

<!-- Soldan kayan menü -->
<div id="sidebar">
  <ul class="list-unstyled">
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="nav-item"><a class="nav-link" title="<?php echo e($category->name); ?> - <?php echo e(config('settings.site_title', 'Varsayılan Başlık')); ?>" href="/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>
  <a class="navbar-brand" href="#">
    <img src="/uploads/logo/<?php echo e(config('settings.sayfa_logo', 'Varsayılan Başlık')); ?>" alt="Haber Code Logo">
  </a>
</div>
  <div class="breaking-news mt-2">
        <div class="container">
            <div class="d-flex align-items-center">
                <div class="incontainer">
                    <i class="bi bi-clock icon"></i>
                    <div class="headline">SON DAKİKA</div>
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="prev" style="margin-left: 30px;" src="/img/chevron-right-2.png" alt="Son Dakika Haberleri Sola Kaydırma İkonu">
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="next" src="/img/chevron-right-3.png" alt="Son Dakika Haberleri Sağa Kaydırma İkonu">
                </div>
                 <div id="breakingNewsCarousel" class="carousel slide breaking-news" data-bs-ride="carousel"  data-bs-interval="2500" >
                    <div class="carousel-inner">
                    <?php 
                    $i=0;
                    ?>
                    <?php $__currentLoopData = $sondakikahaberler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sondakikahaber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $i++ ?>
                      <div class="carousel-item <?php if($i==1): ?> active <?php endif; ?>" style="cursor:pointer">
                        <div class="time"><?php echo e($sondakikahaber->time); ?></div>
                        <div class="news"><a href="/<?php echo e($sondakikahaber->slug); ?>.html" title="<?php echo e($sondakikahaber->name); ?>"><?php echo e($sondakikahaber->name); ?></a></div>
                     </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                    </div>
            </div>
        </div>
    </div>
<script>
  // Menü ikonuna tıklayınca soldan kayan menü açılması
  const menuToggle = document.getElementById('menu-toggle');
  const sidebar = document.getElementById('sidebar');
  menuToggle.addEventListener('click', () => {
    sidebar.classList.toggle('active');
  });
</script>
<?php /**PATH /home/demohabercode/public_html/resources/views/layout/menu5.blade.php ENDPATH**/ ?>