<?php



use App\Http\Controllers\CategoryController;
use App\Http\Controllers\HomepageController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\PhotoGalleryController;
use App\Http\Controllers\NewsWidgetController;
use App\Http\Controllers\TagController;
use App\Http\Controllers\PageController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SitemapController;
use App\Http\Controllers\RssController;
use App\Http\Controllers\ModulController;
use App\Http\Controllers\HoroscopeController;
use App\Http\Controllers\NewsEmojiController;
use App\Http\Controllers\NewsCommentController;
use League\Flysystem\Config;

/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/




Route::get('bot/getstockexchange',[App\Http\Controllers\BotController::class , 'getstockexchange'])->name('bot.getstockexchange');


Route::get('ihaajans', function () {

    \Artisan::call('command:ihaajans');

});


Route::get('GetHoroscope', function () {

    \Artisan::call('command:Horoscope');

});

Route::get('GetWeather', function () {

    \Artisan::call('command:Weather');

});

Route::get('GetWeathers', function () {

    \Artisan::call('command:Weathers');

});

Route::get('GetSoccerBot', function () {

    \Artisan::call('command:GetSoccerBot');

});




Route::get('GetNewspaper', function () {

    \Artisan::call('command:Newspaper');

});

Route::get('GetVision', function () {

    \Artisan::call('command:Vision');

});


Route::get('GetPrayerTimes', function () {

    \Artisan::call('command:PrayerTimes');

});

Route::get('GetPharmacies', function () {

    \Artisan::call('command:Pharmacies');

});


Route::get('searchComments', function () {

    \Artisan::call('command:searchComments');

});


Route::any('/', [HomepageController::class , 'index']);

Route::any('/iletisim', [PageController::class , 'pageIletisim'])->name('page.iletisim');

Route::any('/haberler', [NewsWidgetController::class , 'newspage']);

Route::any('/manset-haberler', [CategoryController::class , 'mansetHaberler']);

Route::get('/nobetci-eczaneler', [ModulController::class, 'FullPharmacies']);

Route::get('/resmi-ilanlar', [ModulController::class, 'FullOfficial']);

Route::get('/vizyondakiler', [ModulController::class, 'FullVisions']);

Route::get('/vizyon/{slug}', [ModulController::class, 'GetVision']);

Route::get('/hava-durumu', [ModulController::class, 'FullWeathers']);

Route::get('/namaz-vakitleri', [ModulController::class, 'FullPrayer']);

Route::any('/yazarlar', [NewsController::class , 'authors']);

Route::any('/pages/{page}', [PageController::class , 'page'])->name('page');

Route::any('/yazar/{yazar}', [NewsController::class , 'authorNewsFull']);

Route::any('/search', [NewsController::class , 'searchNews']);

Route::get('/like/comments', [NewsCommentController::class, 'toggleLike']);

Route::get('/comments/{newsId}', [NewsCommentController::class, 'fetchComments']);

Route::get('/comments', [NewsCommentController::class, 'addComment']);
Route::any('/get-horoscope', [HoroscopeController::class, 'getHoroscope']);

Route::any('/{slug}.html', [NewsController::class , 'News'])->name('news');
Route::any('/amp/{slug}.html', [NewsController::class , 'NewsAmp'])->name('news.amp');

Route::any('/video/{slug}', [VideoController::class , 'Video'])->name('video');

Route::any('/gazete/{slug}', [NewsController::class , 'Gazete'])->name('gazete');

Route::any('/foto-galeri/{slug}', [PhotoGalleryController::class , 'PhotoGallery'])->name('photo_gallery');

Route::any('/foto-galeri/{slug}/{page}', [PhotoGalleryController::class , 'PhotoGalleryPage'])->name('photo_gallery_page');

Route::any('/foto-galeri', [PhotoGalleryController::class , 'PhotoGalleryPages'])->name('photo_gallery_pages');

Route::any('/video-galeri', [VideoController::class , 'VideoPages'])->name('videopages');

Route::any('/create-sitemap', [SitemapController::class, 'index']);

Route::any('/news-sitemap.xml', [SitemapController::class, 'news']);

Route::any('/rss', [RssController::class, 'news']);

Route::post('/load-more-news', [CategoryController::class, 'loadMoreNews'])->name('load.more.news');

Route::post('/load-more-manset', [CategoryController::class, 'loadMoreManset'])->name('load.more.manset');

Route::any('/yazar/{yazar}/{slug}.html', [NewsController::class , 'AuthorsNews'])->name('author.news');

Route::any('/{slug}', [CategoryController::class , 'Category'])->name('category');

Route::any('/etiket/{slug}', [TagController::class , 'Tag'])->name('tag');

Route::get('/haber/sonraki/{id}', [NewsController::class, 'getNextNews'])->name('news.next');


Route::get('/prayer-times/{city}', [HomepageController::class, 'getPrayerTimes']);

Route::get('/weather/{city}', [HomepageController::class, 'getWeather']);

Route::get('/nobetci-eczaneler/{city}', [ModulController::class, 'GetPharmacies']);

Route::get('/resmi-ilan/{slug}', [ModulController::class, 'GetOfficial']);


Route::get('/namaz-vakitleri/{city}', [ModulController::class, 'GetPrayer']);

Route::get('/emoji/update', [NewsEmojiController::class, 'updateEmoji'])->name('emoji.update');

Route::get('/hava-durumu/{city}-15-gunluk', [ModulController::class, 'getWeather15']);

Route::get('/hava-durumu/{city}-7-gunluk', [ModulController::class, 'getWeather7']);

Route::get('/hava-durumu/{city}-10-gunluk', [ModulController::class, 'getWeather10']);
