<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\NewsController;
use App\Http\Controllers\API\AuthorController;
use App\Http\Controllers\API\CategoryController;
use App\Http\Controllers\API\BotController;
use App\Http\Controllers\API\NewsReceiverController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/getCategories', [CategoryController::class , 'getCategories']);
Route::get('/getMainHeadline', [NewsController::class , 'getMainHeadline']);
Route::get('/getFlashNews', [NewsController::class , 'getFlashNews']);
Route::get('/getLastMinutes', [NewsController::class , 'getLastMinutes']);
Route::get('/getHeadlineNews', [NewsController::class , 'getHeadlineNews']);
Route::get('/getAuthors', [AuthorController::class , 'getAuthors']);
Route::get('/getAuthorsNews/{author_id}', [AuthorController::class , 'getAuthorsNews']);
Route::get('/getCategoryNews', [NewsController::class , 'getCategoryNews']);
Route::get('/getVideoGaleries', [NewsController::class , 'getVideoGaleries']);
Route::get('/getPhotoGaleries', [NewsController::class , 'getPhotoGaleries']);
Route::get('/getNews/{id}', [NewsController::class , 'getNews']);
Route::get('/getPhotoGallery/{id}', [NewsController::class , 'getPhotoGallery']);
Route::get('/getVideoGallery/{id}', [NewsController::class , 'getVideoGallery']);
Route::get('/getStockExchanges', [BotController::class , 'getStockExchanges']);
Route::get('/getCategoryFromNewsPopular', [NewsController::class , 'getCategoryFromNewsPopular']);
Route::get('/getCategoryFromNewsLast', [NewsController::class , 'getCategoryFromNewsLast']);

// Haber Alma API Routes
Route::post('/receive-news', [NewsReceiverController::class, 'receiveNews']);
Route::get('/health-check', [NewsReceiverController::class, 'healthCheck']);
