@extends('layout.master')



@section('title',$video->name.' - '. config('settings.site_title', 'Varsayılan Başlık'))
@section('description',$video->short_description ?? config('settings.site_description', 'Varsayılan Başlık'))
@section('image',config('settings.site_url', 'Varsayılan Başlık').'/uploads/images/news/'.date("Y/m/d", strtotime($video->date)).'/'.$video->video_image)



@section('content')

<div class="news-page-custom custom-page-news"  id="site-content" style="background: #fff;padding-left:0px; padding-right: 0px;">
    
    <div class="newsPage container">
          <div class="container mt-5" style="margin-top:30px !important;padding-left:0px; padding-right: 0px;">
          <div class="section-header">
            <h2>VİDEOLAR</h2>
            <div class="line" style="background-color:#FF0000"></div>
          </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                    <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/video-galeri" title="Video Galeri">Video Galeri</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{$video->name}}</li>
            </ol>
        </nav>
            </div>
        </div>



        <div class="row" style="margin-top:20px">
            <div class="col-md-9">

                 <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div class="row" style="width:100%">
                    <div class="col-md-9">
                        <div class="article-title"><h1 class="article-title ">{{ltrim($video->name)}}</h1></div>

                    </div>                  
                </div>
            </div>
        </div>
    </div>

    <div class="row">
                            <div class="col-12">
                                <div class="article-sub-content">
                                    <h2 class="article-sub-content">{!! $video->short_description !!}</h2>
                                </div>
                            </div>
                        </div>
    <div class="row align-items-center">
    <!-- Tarih Bilgisi -->
    <div class="col-md-8 d-flex newsDates">
      <span>Giriş: {{$video->date}} {{$video->time}}</span>
    </div>

    <!-- Paylaşım Simgeleri -->
    <div class="col-md-4 text-end d-flex justify-content-end align-items-center">
      <span class="me-2 newsShare">Paylaş</span>
      <span class="divider"></span>
          <a href="https://www.facebook.com/sharer/sharer.php?u={{ url('video/'.$video->slug) }}" target="_blank" class="mx-2 newsShareIcon">
    <i class="bi bi-facebook"></i>
</a>
<a href="https://twitter.com/intent/tweet?url={{ url('video/'.$video->slug) }}" target="_blank" class="mx-2 newsShareIcon">
    <i class="bi bi-twitter"></i>
</a>
<a href="https://www.linkedin.com/shareArticle?url={{ url('video/'.$video->slug) }}" target="_blank" class="mx-2 newsShareIcon">
    <i class="bi bi-linkedin"></i>
</a>
<a href="https://api.whatsapp.com/send?text={{ url('video/'.$video->slug) }}" target="_blank" class="mx-2 newsShareIcon">
    <i class="bi bi-whatsapp"></i>
</a>
<a href="https://t.me/share/url?url={{ url('video/'.$video->slug) }}" target="_blank" class="mx-2 newsShareIcon">
    <i class="bi bi-telegram"></i>
</a>
    </div>
  </div>
                

    <div class="row">
        <div class="col-12">
            <div class="article-content">
                @if(isset($video->iframe_link))
                <iframe id="frame-video" frameborder="0" allowfullscreen="1" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" title="Bursa Yıldırımspor’da hedef Alanya Kestelspor (Özel Haber)" src="{{$video->iframe_link}}" data-gtm-yt-inspected-9="true"></iframe>
                @endif
                  @if($video->video!="")
              <video
                id="my-video"
                class="video-js"
                controls
                preload="auto"
                width="640"
                height="500"
                poster="{{env('PANEL_URL')}}/uploads/images/news/{{ date("Y/m/d", strtotime($video->date)) }}/{{ $video->video_image  }}"
                data-setup="{}"
              >
                <source src="/uploads/videos/{{$video->video}}" type="video/mp4" />
                </video>
                @endif

            </div>
        </div>
    </div>

    <!-- Article Footer -->


    <div class="row">
        <div class="col-12 article-footer">
    @if(isset($video->tag))
    @php 

    $tagParcala=explode(',',$video->tag);

    @endphp
            <div class="article-tags">
            @foreach($tagParcala as $tag)
                <a href="#">{{$tag}}</a>
                @endforeach
            </div>
            @endif
        </div>
    </div>

      <div class="container newseight" style="margin-top:20px">
            <div class="container mt-5">
        <div class="section-header">
            <h2>{{$category->name}}</h2>
            <div class="line" style="background-color:#{{$category->color}}"></div>
        </div>
    </div>
        <div class="row"  style="margin-top:20px">
           @foreach($categoryhaberlerNews as $ekonomikhaberNews)
            <div class="col-md-4">
                 <div class="news-card">
            <a href="/video/{{$ekonomikhaberNews->slug}}" title="{{$ekonomikhaberNews->name}}"><img src="{{env('PANEL_URL')}}/uploads/images/news/{{ date("Y/m/d", strtotime($ekonomikhaberNews->date)) }}/{{ $ekonomikhaberNews->video_image  }}" style="height:165px"></a>
            <div class="news-badge"style="background-color:#{{$ekonomikhaberNews->category->color}} !important;">{{$ekonomikhaberNews->category->name}}</div>
             <div class="card-body"> <a href="/video/{{$ekonomikhaberNews->slug}}" title="{{$ekonomikhaberNews->name}}"><div class="news-title">{{$ekonomikhaberNews->name}}</div></a></div>
        </div>
            </div>
                        @endforeach
            
           
        </div>
    </div>


            </div>
            <div class="col-md-3">
                <div class="row">
                    <div class="col-md-12 ads">   {!! showAd('903') !!} </div>
                    <div class="col-md-12" style="margin-top:20px">
                        
                         <div class="row">
        <div class="col-12">
           <div class="section-header" style="display: contents;">
                    <h2>En Çok İzlenen Videolar</h2>
                    <div class="line" style="background-color:#FF0000;     margin-top: 5px;"></div>
                  </div>


        <div class="row">
            @foreach($recentNews as $videoOne)
        <a href="/video/{{$videoOne->slug}}" title="{{$videoOne->name}}" style="text-decoration: none;"  ><div class="program-card" >
            <img src="{{env('PANEL_URL')}}/uploads/images/news/{{ date("Y/m/d", strtotime($videoOne->date)) }}/{{ $videoOne->video_image  }}" alt="{{$videoOne->name}}">
            <div class="program-info">
                <div class="program-title">{{$videoOne->name}}</div>
            </div>
        </div></a>
        @endforeach



        </div>
        </div>
    </div>
   

                    </div>

                   
                </div>


            </div>
        </div>
    </div>

</div>
</div>

@endsection


<style>
    
.program-title{
        display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
}


</style>


