
  <style>
    /* Genel Stil Ayarları */
    body {
      font-family: 'Roboto', sans-serif;
    }

    .top-navbar {
      background-color: #ffffff; /* Açık gri arka plan */
      color: black;
      padding: 0.5rem 2rem;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .top-navbar .currency-info {
      font-weight: 700;
      color: #333;
    }

    .top-navbar .currency-info span {
      margin-right: 10px;
    }

    .top-navbar .currency-info .price {
      color: green;
      margin-left: 5px;
    }

    .top-navbar .currency-info .price.red {
      color: red;
    }

    .top-navbar .currency-info i {
      margin-right: 5px;
    }

    .social-media-icons {
      display: flex;
      gap: 10px; /* Daha az boşluk */
    }

    .social-media-icons img {
      height: 20px; /* İkon boyutunu küçülttüm */
    }

    .middle-navbar {
      padding: 0.5rem 2rem;
      padding-left:0px;
      display: flex;
      align-items: center;
      background-color: white;
      border-bottom: 1px solid #ddd;
    }

    .middle-navbar .navbar-brand img {
      height: 40px; /* Logo boyutu daha küçük */
    }

    .bottom-navbar {
      background-color: #524C4C; /* Koyu gri arka plan */
      padding: 0.5rem 2rem;
    }

    .bottom-navbar-icons {
      display: flex;
      gap: 15px; /* Aralarındaki mesafeyi azalttım */
      align-items: center;
    }

    .bottom-navbar-icons a {
      color: #524C4C; /* Yazı rengi koyu gri */
      font-family: 'Roboto', sans-serif;
      font-weight: 600; /* Roboto Semi Bold */
      font-size: 13px; /* Yazı boyutunu küçülttüm */
      text-decoration: none; /* Alt çizgiyi kaldır */
      display: flex;
      align-items: center;
      gap: 5px;
    }

    .bottom-navbar-icons a img {
      height: 18px; /* İkon boyutu daha orantılı */
    }

    .bottom-navbar-icons a:hover {
      color: black; /* Hover durumunda yazı koyu renk */
    }

    .category-navbar {
      background-color: #4A4A4A; /* Daha koyu bir gri */
      padding: 0.5rem 2rem;
    }

    .category-navbar .nav-link {
    color: white !important;
    font-size: 15px;
    font-weight: 600;
    margin-right: 20px;
    line-height: 1.6;
    }

    .menu-icon{
    	display: none;
    }

    .arama-icon{
    	display: none;
    }

    .category-navbar .nav-link:hover {
      color: #FF0000 !important; /* Hover durumunda kırmızı renk */
    }

    /* Mobil Görünüm Ayarları */
    @media (max-width: 768px) {
      .top-navbar {
        display: none; /* Mobilde gizle */
      }

      .category-navbar{
      	display: none;
      }

      .navbar-icons{
      	display: none !important;
      }

      .navbar-icons {
        display: flex;
        align-items: center;
        gap: 15px;
      }

      .bottom-navbar .navbar-brand {
        order: 1; /* Logo sola taşınacak */
      }

      .navbar-icons {
        margin-left: auto;
        order: 3; /* Menü ve arama ikonu sağda kalacak */
      }
      .nav-item{
        margin-top:10px;
      }

       .menu-icon{
    	display: block;
    }

    .arama-icon{
    	display: block;
    }


.navbar-brand {
    width: 100%;
}
       .bottom-navbar {
      padding: 10px !important; /* Genişliği artırmak için padding artırıldı */
    }
    .middle-navbar {
    padding-left: 10px;
}
    }
    /* Soldan kayan menü için */
    #sidebar {
      position: fixed;
      top: 0;
      left: -250px;
      width: 250px;
      height: 100%;
      background: #524C4C;
      color: white;
      transition: left 0.3s;
      padding: 20px;
      z-index: 9999999999;
    }

    #sidebar.active {
      left: 0;
    }

    #sidebar .navbar-brand img {
      margin-top: 20px;
      height: 40px;
    }
       .search-icon, .menu-icon {
      color: black; /* Siyah arama ikonu */
      font-size: 20px;
    }


    hr.custom-hr {
      border: none;
      border-top: 1px solid #C0B2B;
      margin: 0;
    }

    .navbar-icons a{
    	color: #524C4C;
    text-decoration: none;
    font-weight: 600;
    font-size: 15px;
    margin-left: 20px;
    }
  </style>
</head>
<body>

<!-- Üst Bilgilendirme Kısmı -->
<div class="top-navbar container" style="padding-left:5px">
  <div class="currency-info" style="display: none;">
    <!-- Kur bilgileri arkaplanda çalışıyor ama görünmüyor -->
    @if(isset($currencyRates))
      @foreach($currencyRates as $code => $rate)
        <span>{{ $rate['name'] }} <span class="price">{{ $rate['buying'] }}</span></span>
      @endforeach
    @endif
  </div>
  <div class="social-media-icons">
    <a href="{{ config('settings.facebook_adress', 'Varsayılan Başlık') }}"><img src="/menuicons/Facebook.png" alt="Facebook"></a>
    <a href="{{ config('settings.twitter_adress', 'Varsayılan Başlık') }}"><img src="/menuicons/TwitterX.png" alt="TwitterX"></a>
    <a href="{{ config('settings.instagram_adress', 'Varsayılan Başlık') }}"><img src="/menuicons/Instagram.png" alt="Instagram"></a>
    <a href="{{ config('settings.youtube_adress', 'Varsayılan Başlık') }}"><img src="/menuicons/YouTube.png" alt="YouTube"></a>
  </div>
</div>

<hr class="custom-hr"> <!-- İnce HR çizgisi eklendi -->

<!-- Orta Kısım Navbar (Logo ve Menü) -->
<div class="middle-navbar container">
	        <img src="/menuicons/MenuBlack.png"  class="menu-icon" id="menu-toggle" alt="Menü" style="cursor: pointer; height: 25px;">

  <a class="navbar-brand d-flex align-items-center ms-2" href="/">

    <img src="{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}"  alt="Haber Code Logo">

  </a>

  <div class="navbar-icons ms-auto d-flex gap-3">
    <a href="/foto-galeri"><img src="/menuicons/Camera.png" alt="Foto Galeri" style="height: 20px;"> Foto Galeri</a>
    <a href="/video-galeri"><img src="/menuicons/VideoCamera.png" alt="Video Galeri" style="height: 20px;"> Video Galeri</a>
     @if(config('settings.youtube_canli_yayin')!='')
    <a href="{{config('settings.youtube_canli_yayin')}}" rel="nofollow" target="_blank"><img src="/menuicons/BrowsePodcasts.png" alt="Canlı Yayın" style="height: 20px;"> Canlı Yayın</a>
     @endif

    <img src="/menuicons/Search.png" alt="Arama" id="search-icon" style="cursor: pointer; height: 25px;">
  </div>
</div>

<!-- Alt Menü (Kategoriler) -->
<nav class="navbar navbar-expand-lg category-navbar">
  <div class="container-fluid justify-content-start container">
    <ul class="navbar-nav mb-2 mb-lg-0">
      <li class="nav-item"><a class="nav-link" href="/"><img src="/menuicons/home.png" alt="Ana Sayfa" style="height: 26px;    margin-top: -3px;
"></a></li>
     @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach
           
                @foreach($topmenu as $menu)
                <li class="nav-item">
                    <a class="nav-link" href="{{$menu->link}}" title="{{$menu->title}}">{{$menu->title}}</a>
                     </li>
                    @endforeach
    </ul>
  </div>
</nav>

<!-- Soldan kayan menü -->
<div id="sidebar">
  <!-- Kapatma butonu -->
  <div class="sidebar-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h4 style="color: white; margin: 0;">Menü</h4>
    <button id="close-sidebar" style="background: none; border: none; color: white; font-size: 24px; cursor: pointer;">&times;</button>
  </div>
  
  <ul class="list-unstyled">
    @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach
  </ul>
  <a class="navbar-brand" href="/">
    <img src="{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}" alt="Haber Code Logo">
  </a>
</div>
  <div class="breaking-news mt-2">
        <div class="container">
            <div class="d-flex align-items-center">
                <div class="incontainer">
                    <i class="bi bi-clock icon"></i>
                    <div class="headline">SON DAKİKA</div>
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="prev" style="margin-left: 30px;" src="/img/chevron-right-2.png" alt="Son Dakika Haberleri Sola Kaydırma İkonu">
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="next" src="/img/chevron-right-3.png" alt="Son Dakika Haberleri Sağa Kaydırma İkonu">
                </div>
                 <div id="breakingNewsCarousel" class="carousel slide breaking-news" data-bs-ride="carousel"  data-bs-interval="2500" >
                    <div class="carousel-inner">
                    @php 
                    $i=0;
                    @endphp
                    @foreach($sondakikahaberler as $sondakikahaber)
                    @php $i++ @endphp
                      <div class="carousel-item @if($i==1) active @endif" style="cursor:pointer">
                        <div class="time">{{$sondakikahaber->time}}</div>
                        <div class="news"><a href="/{{$sondakikahaber->slug}}.html" title="{{$sondakikahaber->name}}">{{$sondakikahaber->name}}</a></div>
                     </div>
                    @endforeach


                    </div>
                    </div>
            </div>
        </div>
    </div>
<script>
  // Menü ikonuna tıklayınca soldan kayan menü açılması
  document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menu-toggle');
    const sidebar = document.getElementById('sidebar');
    const closeSidebar = document.getElementById('close-sidebar');
    
    // Menü açma
    if (menuToggle && sidebar) {
      menuToggle.addEventListener('click', function(e) {
        e.preventDefault();
        sidebar.classList.add('active');
      });
    }
    
    // Menü kapatma
    if (closeSidebar && sidebar) {
      closeSidebar.addEventListener('click', function(e) {
        e.preventDefault();
        sidebar.classList.remove('active');
      });
    }
    
    // Sidebar dışına tıklayınca kapatma
    if (sidebar) {
      sidebar.addEventListener('click', function(e) {
        if (e.target === sidebar) {
          sidebar.classList.remove('active');
        }
      });
    }
  });
</script>
