
  <style>
    .navbar-custom {
      background-color: #524C4C; /* Üst menü için koyu gri arka plan */
      padding: 0.5rem 1rem;
    }
    .navbar-brand img {
      height: 40px; /* Logo boyutu */
    }
    .nav-link {
      font-family: 'Roboto', sans-serif;
      font-weight: bold;
      font-size: 18px;
    }
    .top-navbar-icons {
      display: flex;
      align-items: center;
      gap: 30px; /* Aralarındaki mesafeyi artırdım */
      justify-content: center; /* Ortalamak için */
      flex: 1; /* Bu öğelerin alanı doldurmasını sağlar */
          margin-right: 80px;
    }
    .top-navbar-icons a {
      color: #CCCCCC; /* Yazı rengi */
      font-family: 'Roboto', sans-serif;
      font-weight: 600; /* Roboto Semi Bold */
      font-size: 14px;
      text-decoration: none; /* Alt çizgiyi kaldır */
    }
    .top-navbar-icons a:hover {
      color: white !important; /* Hover durumunda beyaz renk */
    }
    .navbar-icons {
      display: flex;
      align-items: center;
      margin-left: auto;
    }
    .search-icon {
      color: white;
      font-size: 20px;
    }
    /* Alt Menü Stili */
    .bottom-navbar {
      background-color: #ffffff;
      padding: 0.5rem 1rem;
    }
    .bottom-navbar .nav-link {
      color: #524C4C !important; /* Menü yazı rengi */
      font-size: 16px;
    }
    .menu-icon {
      color: white;
      font-size: 20px;
      margin-right: 15px;
    }
    /* Mobilde (max-width: 768px) Foto Galeri, Yazarlar, Canlı Yayın gizlenecek ve header düzenlenecek */
    @media (max-width: 768px) {
      .top-navbar-icons {
        display: none; /* Mobilde gizle */
      }
      .navbar-icons {
        display: flex; /* Mobilde menü ikonu ve arama ikonu göster */
        margin-left: auto;
      }
      .nav-item{
        margin-top:10px;
      }
      .navbar-brand {
        flex-grow: 1; /* Logo ortada kalacak şekilde ayarlama */
        display: flex;
        justify-content: center;
      }
    }
     @media (min-width: 769px) {
  
          .search-icon {
         display: block; 
    }
    }
    /* Soldan kayan menü için */
    #sidebar {
      position: fixed;
      top: 0;
      left: -250px;
      width: 250px;
      height: 100%;
      background: #524C4C;
      color: white;
      transition: left 0.3s;
      padding: 20px;
      z-index: 9999999999;
    }
    #sidebar.active {
      left: 0;
    }
    #sidebar .navbar-brand img {
      margin-top: 20px;
      height: 40px;
    }
  </style>
</head>

<!-- Header Bölümü Başlangıcı -->
<div class="header-container">
  <!-- Üst Kısım Navbar -->
  <nav class="navbar navbar-expand-lg navbar-custom">
    <div class="container-fluid d-flex align-items-center container">
      <i id="menu-toggle" class="bi bi-list menu-icon d-lg-none"></i>
      <a class="navbar-brand d-flex align-items-center" href="/">
        <img src="/uploads/logo/{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}" alt="Haber Code Logo">
      </a>
      <div class="top-navbar-icons d-flex justify-content-center d-none d-lg-flex">
        <a href="/foto-galeri"><i class="bi bi-camera"></i> Foto Galeri</a>
        <a href="/video-galeri"><i class="bi bi-film"></i> Video Galeri</a>
        <a href="/yazarlar"><i class="bi bi-pen"></i> Yazarlar</a>
        @if(config('settings.youtube_canli_yayin')!='')
        <a href="{{config('settings.youtube_canli_yayin')}}"><i class="bi bi-broadcast"></i> Canlı Yayın</a>
        @endif
      </div>
      <div class="navbar-icons ms-auto" id="search-icon">
        <i class="bi bi-search search-icon"></i>
      </div>
    </div>
  </nav>

  <!-- Alt Kısım Navbar (Kategori) -->
  <nav class="navbar navbar-expand-lg bottom-navbar">
    <div class="container-fluid container">
      <div class="collapse navbar-collapse">
        <ul class="navbar-nav mb-2 mb-lg-0">
       @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach
    </ul>
        </ul>
      </div>
    </div>
  </nav>
</div>
<!-- Header Bölümü Sonu -->

<!-- Soldan kayan menü -->
<div id="sidebar">
  <ul class="list-unstyled">
   @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach

            @foreach($topmenu as $menu)
                <li class="nav-item">
                    <a class="nav-link" href="{{$menu->link}}" title="{{$menu->title}}">{{$menu->title}}</a>
                     </li>
                    @endforeach
    </ul>
  </ul>
  <a class="navbar-brand" href="#">
    <img src="/uploads/logo/{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}" alt="Haber Code Logo">
  </a>
</div>
  <div class="breaking-news">
        <div class="container">
            <div class="d-flex align-items-center">
                <div class="incontainer">
                    <i class="bi bi-clock icon"></i>
                    <div class="headline">SON DAKİKA</div>
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="prev" style="margin-left: 30px;" src="/img/chevron-right-2.png" alt="Son Dakika Haberleri Sola Kaydırma İkonu">
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="next" src="/img/chevron-right-3.png" alt="Son Dakika Haberleri Sağa Kaydırma İkonu">
                </div>
                 <div id="breakingNewsCarousel" class="carousel slide breaking-news" data-bs-ride="carousel"  data-bs-interval="2500" >
                    <div class="carousel-inner">
                    @php 
                    $i=0;
                    @endphp
                    @foreach($sondakikahaberler as $sondakikahaber)
                    @php $i++ @endphp
                      <div class="carousel-item @if($i==1) active @endif" style="cursor:pointer">
                        <div class="time">{{$sondakikahaber->time}}</div>
                        <div class="news"><a href="/{{$sondakikahaber->slug}}.html" title="{{$sondakikahaber->name}}">{{$sondakikahaber->name}}</a></div>
                     </div>
                    @endforeach


                    </div>
                    </div>
            </div>
        </div>
    </div>

<script>
  // Menü ikonuna tıklayınca soldan kayan menü açılması
  const menuToggle = document.getElementById('menu-toggle');
  const sidebar = document.getElementById('sidebar');
  menuToggle.addEventListener('click', () => {
    sidebar.classList.toggle('active');
  });
</script>
