<div class="header-container ">
  <nav class="navbar navbar-expand-lg navbar-light bg-light px-3 position-relative container" style="background-color: #fff !important;">
    <a class="navbar-brand" href="/">
      <img src="/uploads/logo/{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}" alt="Haber Code Logo">
    </a>
    <div class="ms-auto d-flex align-items-center nav-right">
      <div id="currency-info" class="currency-info me-3">
        {{$exchanges->first()->long_name}} <span class="price">{{$exchanges->first()->value}}</span> 
        <span class="change">@if($exchanges->first()->status==1) ▲ @else ▼ @endif {{$exchanges->first()->last}}</span>
      </div>
      <div class="location-info me-3">
        {{config('settings.main_city')}} <br />{{(date('d.m.Y'))}}
      </div>
      <div class="temperature-info d-flex align-items-center">
        <img src="/img/Rain.png" alt="Weather Icon"> {{ config('settings.weather_degree', '') }}
      </div>
      <!-- Mobilde ve webde ikonlar -->
      <div class="navbar-icons" id="search-icon">
        <i class="bi bi-search search-icon" style="color:#6B6B6B"></i>
        <i id="menu-toggle" class="bi bi-list menu-icon" style="color:#6B6B6B"></i>
      </div>
    </div>
  </nav>

  <nav class="navbar navbar-expand-lg navbar-custom">
    <div class="container-fluid container">
      <div class="collapse navbar-collapse">
        <ul class="navbar-nav mb-2 mb-lg-0">
          @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach

            @foreach($topmenu as $menu)
                <li class="nav-item">
                    <a class="nav-link" href="{{$menu->link}}" title="{{$menu->title}}">{{$menu->title}}</a>
                     </li>
                    @endforeach
          
        </ul>
        <!-- Webde ikonlar en sağda olacak şekilde -->
        <div class="navbar-icons d-none d-lg-flex" id="search-icon">
          <i class="bi bi-search search-icon"></i>
        </div>
      </div>
    </div>
  </nav>
</div>
<!-- Header Bölümü Sonu -->

<!-- Soldan kayan menü -->
<div id="sidebar">
  <ul class="list-unstyled">
   @foreach($categories as $category)
          <li class="nav-item"><a class="nav-link" title="{{$category->name}} - {{config('settings.site_title', 'Varsayılan Başlık')}}" href="/{{$category->slug}}">{{$category->name}}</a></li>
           @endforeach
  </ul>
  <a class="navbar-brand" href="/">
    <img src="/uploads/logo/{{ config('settings.sayfa_logo', 'Varsayılan Başlık') }}" alt="Haber Code Logo">
  </a>
</div>
   <div class="breaking-news">
        <div class="container">
            <div class="d-flex align-items-center">
                <div class="incontainer">
                    <i class="bi bi-clock icon"></i>
                    <div class="headline">SON DAKİKA</div>
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="prev" style="margin-left: 30px;" src="/img/chevron-right-2.png" alt="Son Dakika Haberleri Sola Kaydırma İkonu">
                   <img class="chevron-right-3" data-bs-target="#breakingNewsCarousel" data-bs-slide="next" src="/img/chevron-right-3.png" alt="Son Dakika Haberleri Sağa Kaydırma İkonu">
                </div>
                 <div id="breakingNewsCarousel" class="carousel slide breaking-news" data-bs-ride="carousel"  data-bs-interval="2500" >
                    <div class="carousel-inner">
                    @php 
                    $i=0;
                    @endphp
                    @foreach($sondakikahaberler as $sondakikahaber)
                    @php $i++ @endphp
                      <div class="carousel-item @if($i==1) active @endif" style="cursor:pointer">
                        <div class="time">{{$sondakikahaber->time}}</div>
                        <div class="news"><a href="/{{$sondakikahaber->slug}}.html" title="{{$sondakikahaber->name}}">{{$sondakikahaber->name}}</a></div>
                     </div>
                    @endforeach


                    </div>
                    </div>
            </div>
        </div>
    </div>

<script>
  const currencyInfoElement = document.getElementById('currency-info');
  let index = 0;

  const currencies = [

  @foreach($exchanges as $exchange)
    { type: '{{$exchange->long_name}}', price: '{{$exchange->value}}', change: '@if($exchange->status==1) ▲ @else ▼ @endif {{$exchange->last}}', color: '@if($exchange->status==1) green @else red @endif' },
         @endforeach

  ];

  function updateCurrency() {
    index = (index + 1) % currencies.length;
    const currentCurrency = currencies[index];
    currencyInfoElement.innerHTML = `
      ${currentCurrency.type} <span class="price">${currentCurrency.price}</span> 
      <span class="change" style="color: ${currentCurrency.color}">${currentCurrency.change}</span>
    `;
  }

  setInterval(updateCurrency, 3000); // 10 saniyede bir döviz bilgisini değiştir

  // Menü ikonuna tıklayınca soldan kayan menü açılması
  const menuToggle = document.getElementById('menu-toggle');
  const sidebar = document.getElementById('sidebar');
  menuToggle.addEventListener('click', () => {
    sidebar.classList.toggle('active');
  });
</script>



  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">

<style>
    .navbar-custom {
      background-color: #524C4C; /* Menü için koyu gri arka plan */
    }
    .navbar-brand img {
      height: 40px; /* Logo boyutu */
    }
    .nav-link {
      color: white !important;
      font-family: 'Roboto', sans-serif;
      font-weight: bold;
      font-size: 18px;
    }
    .currency-info {
      color: #6A7178;
      font-family: 'Roboto', sans-serif;
      font-weight: 900; /* Roboto Black */
      font-size: 14px;
    }
    .currency-info .change {
      color: #22853E; /* Artış rengi */
      font-weight: 900; /* Roboto Black */
      font-size: 14px;
    }
    .location-info {
      color: #6A7178;
      font-family: 'Roboto', sans-serif;
      font-weight: 500; /* Roboto Medium */
      margin-left: 15px;
      font-size: 14px;
    }
    .temperature-info {
      color: #999999;
      font-family: 'Roboto', sans-serif;
      font-weight: 500; /* Roboto Medium */
      margin-left: 15px;
      font-size: 14px;
    }
    .temperature-info img {
      width: 20px;
      height: 20px;
      margin-right: 5px;
    }
    .search-icon, .menu-icon {
      color: white;
      font-size: 20px;
      margin-left: 15px;
    }
    .navbar-icons {
      display: flex;
      align-items: center;
    }
    /* Mobil görünümde ikonların logonun sağında olması */
    @media (max-width: 768px) {
      .navbar-icons {
        position: absolute;
        top: 10px;
        right: 10px;
      }
      .nav-item{
        margin-top:10px;
      }
      .navbar-brand {
        margin-bottom: 20px; /* Mobilde logonun altına boşluk ekleme */
      }
      .nav-right{
        margin:0 auto !important;
      }
    }
    @media (min-width: 769px) {
      .navbar-icons {
        position: static;
        margin-left: auto;
        display: none;
      }
          .search-icon {
         display: block; 
    }
    }
    /* Soldan kayan menü için */
    #sidebar {
      position: fixed;
      top: 0;
      left: -250px;
      width: 250px;
      height: 100%;
      background: #524C4C;
      color: white;
      transition: left 0.3s;
      padding: 20px;
      z-index: 1000;
          z-index: 9999999999999999999;
    }
    #sidebar.active {
      left: 0;
    }
    #sidebar .navbar-brand img {
      margin-top: 20px;
      height: 40px;
    }

</style>

