
<!doctype html>
<html ⚡ lang="tr">

 
       
<head>

    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
    <link rel="canonical" href="https://{{$_SERVER['SERVER_NAME']}}/{{$news->slug}}.html">
    <link rel="shortcut icon" href="{{ config('settings.favicon', 'Varsayılan Başlık') }}">

    <title>{{$news->name}} -  {{config('settings.site_title', 'Varsayılan Başlık')}}</title>
    <style amp-boilerplate>
        body {
            -webkit-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
            -moz-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
            -ms-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
            animation: -amp-start 8s steps(1,end) 0s 1 normal both
        }

        @-webkit-keyframes -amp-start {
            from {
                visibility: hidden
            }

            to {
                visibility: visible
            }
        }

        @-moz-keyframes -amp-start {
            from {
                visibility: hidden
            }

            to {
                visibility: visible
            }
        }

        @-ms-keyframes -amp-start {
            from {
                visibility: hidden
            }

            to {
                visibility: visible
            }
        }

        @-o-keyframes -amp-start {
            from {
                visibility: hidden
            }

            to {
                visibility: visible
            }
        }

        @keyframes -amp-start {
            from {
                visibility: hidden
            }

            to {
                visibility: visible
            }
        }</style>
    <noscript>
        <style amp-boilerplate>
            body {
                -webkit-animation: none;
                -moz-animation: none;
                -ms-animation: none;
                animation: none
            }</style>
    </noscript>
    <style amp-custom>
        :root {
            --base-margin-x: 1rem;
            --primary-color: #f71515;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
            width: auto;
            margin: 0;
            padding: 0;
        }

        header {
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--primary-color);
            height: 55px;
            color: white;
            font-size: 2em;
            text-align: center;
            margin-bottom: 24px;
        }

        article {
            width: 100%;
            max-width: 768px;
            margin: auto auto 2rem;
        }

        .breadcrumb {
            margin: 0 var(--base-margin-x) 1.5rem;
        }

            .breadcrumb > a {
                text-decoration: none;
                color: initial;
                font-weight: bold;
            }

                .breadcrumb > a:last-child {
                    color: var(--primary-color);
                }

        .article-header {
            margin: 0 1rem var(--base-margin-x);
        }

        h1 {
            margin: 0;
            background: white;
        }

        .article-header p {
            font-size: 18px;
            line-height: 1.5;
            font-weight: 500;
        }

        .divider {
            display: block;
            height: 1px;
            width: 100%;
            background-color: #dedede;
            margin-bottom: 1rem;
        }

        .content-meta-name {
            margin-bottom: .5rem;
        }

            .content-meta-name span {
                color: #444;
            }

        .content-meta-dates {
            font-size: .8rem;
            color: #666;
        }

        .main-image {
            margin-bottom: 1.5rem;
        }

        .share {
            margin: 0 var(--base-margin-x) 1.5rem;
        }

        .content {
            margin: 0 var(--base-margin-x) 2rem;
        }

            .content h2 {
                font-size: 1.375rem;
            }

            .content p {
                font-size: 18px;
                line-height: 1.5;
            }

        .relateds {
            margin: 0 var(--base-margin-x) 0;
        }

        .related a {
            display: block;
            margin-bottom: 1.5rem;
        }

        .relateds h3 {
            border-bottom: 1px solid #dedede;
            padding-bottom: 1rem;
        }

        .related a:first-child {
            margin-bottom: .75rem;
        }

        .related a:last-child {
            display: flex;
            align-items: center;
            text-decoration: none;
            font-weight: bold;
            color: initial;
            font-size: 1.125rem;
        }
        .ad{
            display:flex;
            align-items:center;
            justify-content:center;
            margin:24px 0;
        }
    </style>
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <script type="application/ld+json">
        {"@context":"https://schema.org","@type":"NewsArticle","mainEntityOfPage":"https://{{$_SERVER['SERVER_NAME']}}/{{$news->slug}}.html","headline":"{{$news->name}}","articleSection":"{{mb_convert_case($news->category->name, MB_CASE_TITLE, 'UTF-8')}}","image":["{{ env('PANEL_URL') }}/uploads/images/news/{{ date('Y/m/d', strtotime($news->date)) }}/{{$news->news_image}}"],"datePublished":"{{$news->date}} {{$news->time}}","dateCreated":null,"dateModified":"2{{$news->date}} {{$news->time}}","genre":null,"wordCount":265,"inLanguage":"tr","typicalAgeRange":null,"keywords":null,"author":[{"@type":"Person","name":"Haber Merkezi"}],"publisher":{"@type":"Organization","name":"HaberCode","logo":{"@type":"ImageObject","url":"{{ config('settings.amp_logo', 'Varsayılan Başlık') }}","width":192,"height":192}},"description":"{{$news->short_description}}","editor":null}
    </script>
    <script async custom-element="amp-social-share" src="https://cdn.ampproject.org/v0/amp-social-share-0.1.js"></script>
    <script async custom-element="amp-iframe" src="https://cdn.ampproject.org/v0/amp-iframe-0.1.js"></script>
    <script async custom-element="amp-ad" src="https://cdn.ampproject.org/v0/amp-ad-0.1.js"></script>
    <script async custom-element="amp-analytics" src="https://cdn.ampproject.org/v0/amp-analytics-0.1.js"></script>
         
            <script async custom-element="amp-youtube" src="https://cdn.ampproject.org/v0/amp-youtube-0.1.js"></script>
</head>



<body>
    <header>
        <a href="/">
            <amp-img src="{{ config('settings.amp_logo', 'Varsayılan Başlık') }}" layout="fixed" width="119" height="40"></amp-img>
        </a>
    </header>
<article>
    <div class="d-flex align-items-center justify-content-between mb-4 breadcrumb">
        <a href="https://{{$_SERVER['SERVER_NAME']}}" class="text-muted small fw-bold lh-1">Haberler -</a>
        <a href="https://{{$_SERVER['SERVER_NAME']}}/{{$news->category->slug}}" class="small fw-bold text-primary text-nowrap lh-1">{{mb_convert_case($news->category->name, MB_CASE_TITLE, "UTF-8")}}</a>
    </div>
    <div class="article-header">
        <h1>{{$news->name}}</h1>
        <p>{{$news->short_description}}</p>
        <div class="divider"></div>
        <div class="content-meta mb-4">
            <div class="content-meta-dates">
                <span class="content-meta-date"><span>Yayınlanma:</span> <time datetime="{{$news->date}} {{$news->time}}">{{$news->date}} {{$news->time}}</time></span>
                <span class="content-meta-date"><span>Güncellenme:</span> <time datetime="{{$news->change_date_time}}">{{$news->change_date_time ?? $news->date}}</time></span>
            </div>
        </div>
    </div>
 <amp-img id="254435" class="data-image" src="{{ env('PANEL_URL') }}/uploads/images/news/{{ date('Y/m/d', strtotime($news->date)) }}/{{$news->news_image}}" data-id="254435" layout="responsive" width="776" height="436" alt="{{$news->name}}"></amp-img>
           
    <div class="share">
        <amp-social-share type="whatsapp" aria-label="Share on WhatsApp"></amp-social-share>
        <amp-social-share type="facebook" aria-label="Share on Facebook" data-param-app_id="1104414796238524"></amp-social-share>
        <amp-social-share type="twitter" aria-label="Share on Twitter"></amp-social-share>
        <amp-social-share type="linkedin" aria-label="Share on LinkedIn"></amp-social-share>
        <amp-social-share type="email" aria-label="Share by email"></amp-social-share>
    </div>
    
    <div class="content">
    @php 
$description = $news->description;
$description = str_replace('height', '/', $description);
$description = str_replace('<img', '<amp-img', $description);
$description = str_replace('oembed url', 'iframe frameborder="0" allowfullscreen="1" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" style="width: 100%;height: 500px" src', $description);
$description = str_replace('</oembed>', '</iframe>', $description);

$paragraphs = preg_split('/(<\/p>)/i', $description, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);

$description = preg_replace('/<figure[^>]*>.*?<\/figure>/s', '', $description);



@endphp

{!! $description !!}



    </div>
   
   
</article>

  <amp-analytics type="gtag" data-credentials="include">
      <script type="application/json">
      {
        "vars" : {
          "gtag_id": "G-ZWWTF0PEK1",
          "config" : {
            "G-GG5P6V2SE4": { "groups": "default" }
          }
        }
      }
      </script>
      </amp-analytics> 
</body>
 
</html>