<?php


namespace App\Http\Controllers\API;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller as Controller;


class BaseController extends Controller
{


    public static $per_page_item = 10;
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendResponse($result, $message = "", $pageable = true)
    {


        $pagination = null;
        if (!is_null($result)) {

            try {
                $pagination = ['total_item' => $result->total() ?? '0',
                    'current_page' => $result->currentPage(),
                    'last_page' => $result->lastPage(),
                ];
            } catch (\Exception $e) {
                $pagination = null;
            }
        }
        $response = [
            'success' => true,
            'data' => $result,
            'message' => $message,
            'pagination' => $pagination
        ];


        return response()->json($response, 200);
    }


    /**
     * return error response.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendError($error, $errorMessages = [], $code = 404)
    {
        $response = [
            'success' => false,
            'message' => $error,
        ];


        if (!empty($errorMessages)) {
            $response['data'] = $errorMessages;
        }


        return response()->json($response, $code);
    }

    public function sendSuccess($success, $successMessages = [], $code = 200)
    {
        $response = [
            'success' => true,
            'message' => $success,
        ];


        if (!empty($successMessages)) {
            $response['data'] = $successMessages;
        }


        return response()->json($response, $code);
    }


    public function getParentModelApi($model, $request_data, $column = NULL)
    {

        if ($request_data != '' && $request_data != null) {
            if ($column != null) {
                $parent_model = $model::where($column, $request_data)->first();
            } else {
                $parent_model = $model::find($request_data);
            }

            if ($parent_model == null) {
                return false;
            } else {
                return $parent_model->id;
            }
        } else {
            return null;
        }

    }

    public function getParentId($model, $request_id_data, $request_code_data, $column)
    {
        $return = null;
        $parent_id = $this->getParentModelApi($model, $request_code_data, $column);
        $return = $parent_id;


        if ($return == null || $return == false) {
            $parent_id = $this->getParentModelApi($model, $request_id_data);

            $return = $parent_id;

        }

        return $return;

    }


    public function findId($id, $model)
    {

        $model_in = $model::where('integration_code', $id)->first();
        if ($model_in == null) {
            $model_in = $model::find($id);
        }

        return $model_in;
    }

    public function requestIdCodeCheck($id, $integration_code)
    {
        if ($id == null && $integration_code == null) {
            return false;
        }

        if ($id != null && $id == '') {
            return false;
        }

        if ($integration_code != null && $integration_code == '') {
            return false;
        }
    }
}
