<?php
/**
 * Alt Site Migration Runner
 * Bu dosyayı alt site root dizinine koyun
 */

echo "<h1>🔧 Alt Site Migration Runner</h1>";
echo "<style>
body{font-family:Arial;margin:20px;background:#f5f5f5;}
.container{max-width:800px;margin:0 auto;background:white;padding:20px;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
.success{color:green;background:#d4edda;padding:10px;border-radius:5px;margin:10px 0;}
.error{color:red;background:#f8d7da;padding:10px;border-radius:5px;margin:10px 0;}
.info{color:blue;background:#d1ecf1;padding:10px;border-radius:5px;margin:10px 0;}
.step{background:#fff3cd;padding:15px;border-radius:5px;margin:10px 0;border-left:4px solid #ffc107;}
</style>";

echo "<div class='container'>";

// Güvenlik kontrolü
$allowedIPs = ['127.0.0.1', '::1'];
$clientIP = $_SERVER['REMOTE_ADDR'] ?? '';

if (!in_array($clientIP, $allowedIPs)) {
    echo "<div class='error'>❌ Güvenlik: Bu script sadece localhost'tan çalıştırılabilir!</div>";
    echo "<p>IP'niz: " . $clientIP . "</p>";
    echo "<p>Eğer kendi sunucunuzdaysanız, bu kontrolü kaldırabilirsiniz.</p>";
    echo "<p><a href='?skip_security=1'>Güvenlik kontrolünü atla</a></p>";
    
    if (!isset($_GET['skip_security'])) {
        exit;
    }
}

echo "<div class='step'>";
echo "<h2>📋 Alt Site Migration Ne Yapacak?</h2>";
echo "<p>Bu migration şu yeni alanları <strong>news</strong> tablosuna ekleyecek:</p>";
echo "<ul>";
echo "<li><strong>is_shared</strong> - Haber paylaşıldı mı? (0=Hayır, 1=Evet)</li>";
echo "<li><strong>source_site</strong> - Haber nereden geldi? (main_site veya local)</li>";
echo "<li><strong>original_news_id</strong> - Ana sitedeki orijinal haber ID'si</li>";
echo "<li><strong>shared_at</strong> - Ne zaman paylaşıldı?</li>";
echo "</ul>";
echo "</div>";

try {
    echo "<div class='info'>🔄 Laravel başlatılıyor...</div>";
    
    $app = require_once __DIR__ . '/vendor/autoload.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    
    echo "<div class='success'>✅ Laravel başarıyla başlatıldı!</div>";
    
    echo "<div class='step'>";
    echo "<h2>🚀 Alt Site Migration Başlatılıyor...</h2>";
    echo "<p>Lütfen bekleyin, veritabanı güncelleniyor...</p>";
    echo "</div>";
    
    $exitCode = $kernel->call('migrate', [
        '--force' => true
    ]);
    
    if ($exitCode === 0) {
        echo "<div class='success'>";
        echo "<h2>🎉 Alt Site Migration Başarıyla Tamamlandı!</h2>";
        echo "<p>✅ news tablosuna yeni alanlar eklendi</p>";
        echo "<p>✅ Haber alma sistemi hazır</p>";
        echo "</div>";
        
        // Senkronizasyon komutunu test et
        echo "<div class='info'>🔄 Senkronizasyon komutu test ediliyor...</div>";
        $syncExitCode = $kernel->call('news:sync-from-main');
        
        if ($syncExitCode === 0) {
            echo "<div class='success'>✅ Senkronizasyon komutu çalışıyor!</div>";
        } else {
            echo "<div class='error'>❌ Senkronizasyon komutu hatası!</div>";
            echo "<pre>" . $kernel->output() . "</pre>";
        }
        
        echo "<div class='step'>";
        echo "<h2>🎯 Sonraki Adımlar:</h2>";
        echo "<ol>";
        echo "<li>✅ Migration tamamlandı</li>";
        echo "<li>⚙️ Cron job kurun</li>";
        echo "<li>🧪 Ana siteden haber gönderimi test edin</li>";
        echo "</ol>";
        echo "</div>";
        
    } else {
        echo "<div class='error'>";
        echo "<h2>❌ Migration Hatası!</h2>";
        echo "<pre>" . $kernel->output() . "</pre>";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "<div class='error'>";
    echo "<h2>❌ Hata Oluştu!</h2>";
    echo "<p><strong>Hata:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>Dosya:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Satır:</strong> " . $e->getLine() . "</p>";
    echo "</div>";
}

echo "<hr>";
echo "<div class='info'>";
echo "<h3>🔒 Güvenlik Notu:</h3>";
echo "<p>Migration tamamlandıktan sonra bu dosyayı mutlaka silin!</p>";
echo "<p><a href='?delete=1' style='background:red;color:white;padding:10px;text-decoration:none;border-radius:5px;'>Bu Dosyayı Sil</a></p>";
echo "</div>";

// Dosyayı silme
if (isset($_GET['delete']) && $_GET['delete'] == '1') {
    if (unlink(__FILE__)) {
        echo "<div class='success'>✅ Dosya başarıyla silindi!</div>";
    } else {
        echo "<div class='error'>❌ Dosya silinemedi! Manuel olarak silin.</div>";
    }
}

echo "</div>";
?>
