<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('news', function (Blueprint $table) {
            $table->tinyInteger('is_shared')->default(0)->after('status');
            $table->string('source_site')->nullable()->after('is_shared');
            $table->integer('original_news_id')->nullable()->after('source_site');
            $table->timestamp('shared_at')->nullable()->after('original_news_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('news', function (Blueprint $table) {
            $table->dropColumn(['is_shared', 'source_site', 'original_news_id', 'shared_at']);
        });
    }
};
