<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('category_id')->nullable();
            $table->integer('source_id')->nullable();
            $table->string('date')->nullable();
            $table->string('time')->nullable();
            $table->string('color')->nullable();
            $table->string('name')->nullable();
            $table->string('short_description')->nullable();
            $table->text('description')->nullable();
            $table->integer('article_id')->nullable();
            $table->integer('photo_gallary_id')->nullable();
            $table->integer('video_gallary_id')->nullable();
            $table->integer('author_id')->nullable();
            $table->string('views_count')->nullable();
            $table->integer('status')->nullable();
            $table->string('integration_code')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news');
    }
}
