<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Setting;
use Illuminate\Support\Facades\Config;

class DatabaseConfigServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Veritabanından tüm ayarları çek
        $settings = Setting::all();

        // Her ayarı config'e ekle
        foreach ($settings as $setting) {
            Config::set('settings.' . $setting->key, $setting->value);
        }
    }

    public function register()
    {
        //
    }
}