<?php



namespace App\Providers;



use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\News;
use App\Models\Menu;
use App\Models\Exchange;
use App\Models\Video;
use App\Models\PhotoGallery;
use App\Models\Category;
use App\Models\PrayerTimes;
use App\Models\Weathers;
use App\Models\Pharmacies;
use App\Services\SimpleCurrencyService;

class AppServiceProvider extends ServiceProvider

{

    /**

     * Register any application services.

     *

     * @return void

     */

    public function register()

    {

        //

    }



    /**

     * Bootstrap any application services.

     *

     * @return void

     */

    public function boot()

    {

      View::composer(['layout.header', 'layout.footer', 'layout.menu', 'layout.menu2', 'layout.menu3', 'layout.menu4', 'layout.menu5'], function ($view) {
         $sondakikahaberler=News::orderBy('id','desc')->limit(20)->get();
         $categories=category::where('menu_settings','1')->orderBy('code','ASC')->get();
            $topmenu=Menu::orderBy('page_order', 'asc')->where('type',3)->get();
        // $exchanges=Exchange::orderBy('exchange_order', 'asc')->where('type',1)->get(); // Pasif - yavaşlatıyor
        $exchanges = collect(); // Boş collection
        
        // Kur servisini ekle (pasif - sadece arkaplanda)
        $currencyService = app(SimpleCurrencyService::class);
        $currencyRates = $currencyService->getFormattedRates();
        
            $view->with('sondakikahaberler', $sondakikahaberler)
                 ->with('categories', $categories)
                 ->with('topmenu', $topmenu)
                 ->with('exchanges', $exchanges)
                 ->with('currencyRates', $currencyRates);
        });

      View::composer(['categories.widget.bist100'], function ($view) {
            $exchanges=Exchange::orderBy('exchange_order', 'asc')->where('type',1)->get();
            $Greenexchanges=Exchange::orderBy('last', 'asc')->where('type',2)->get();
            $Redexchanges=Exchange::orderBy('last', 'asc')->where('type',3)->get();
            $Popexchanges=Exchange::orderBy('last', 'asc')->where('type',4)->limit(5)->get();
            $view->with('exchanges', $exchanges)
            ->with('Greenexchanges', $Greenexchanges)
            ->with('Redexchanges', $Redexchanges)
            ->with('Popexchanges', $Popexchanges);
        });

         View::composer(['home_modules.pariteler'], function ($view) {
                    $exchanges=Exchange::orderBy('exchange_order', 'asc')->where('type',1)->get();
                    $view->with('exchanges', $exchanges);
                });


        View::composer(['home_modules.coins'], function ($view) {
                    $exchanges=Exchange::orderBy('exchange_order', 'asc')->where('type',10)->limit(7)->get();
                    $view->with('exchanges', $exchanges);
                });

         View::composer(['home_modules.videogaleri'], function ($view) {

                    $videolar=Video::orderBy('created_at', 'desc')->limit(9)->get();
                    $VideolastFirst=$videolar->slice(0, 1)->first();
                    $VideolastThree=$videolar->slice(1, 4);
                    $VideolastEight=$videolar->slice(5, 4);
                    $view->with('VideolastFirst', $VideolastFirst)->with('VideolastThree', $VideolastThree)->with('VideolastEight', $VideolastEight);
                });

          View::composer(['home_modules.fotogaleri'], function ($view) {

                    $fotogaleri=PhotoGallery::orderBy('created_at', 'desc')->limit(5)->get();
                    $PhotoGallerylastFirst=$fotogaleri->slice(0, 1)->first();
                    $PhotoGallerylastEight=$fotogaleri->slice(1, 4);
                    $view->with('PhotoGallerylastFirst', $PhotoGallerylastFirst)->with('PhotoGallerylastEight', $PhotoGallerylastEight);
                });


          View::composer(['home_modules.surmanset'], function ($view) {

                     $surmanset=News::where('status',1)->where('is_mainheadline','1')->orderBy('created_at', 'desc')->limit(5)->get();

                    $view->with('surmanset', $surmanset);
                });


           View::composer(['home_modules.threehaberler'], function ($view) {
                    $bursasporhaberlerlasts = News::where('status', 1)
                                        ->where('category_id', 16)
                                        ->orderBy('created_at', 'desc')
                                        ->skip(9)
                                        ->take(6)
                                        ->get();

                                          $mansethaberlerlasts = News::where('status', 1)
                                        ->where('is_headline','1')
                                        ->orderBy('created_at', 'desc')
                                        ->skip(29)
                                        ->take(6)
                                        ->get();



                         $ekonomihaberlerlasts =News::where('status', 1)
                                        ->where('category_id', 12)
                                        ->orderBy('created_at', 'desc')
                                        ->skip(9)
                                        ->take(6)
                                        ->get();
                    $view->with('bursasporhaberlerlasts', $bursasporhaberlerlasts)->with('mansethaberlerlasts', $mansethaberlerlasts)->with('ekonomihaberlerlasts', $ekonomihaberlerlasts);
                });



           View::composer(['home_modules.anamanset'], function ($view) {

                    $mansethaberlergenel = News::where('status', 1)->where('is_headline','1')
                    ->orderBy('created_at', 'desc')
                    ->limit(29)
                    ->get();
        $mansethaberler=$mansethaberlergenel->slice(0, 15);
        $mansethaberlerlasteight=$mansethaberlergenel->slice(15,8);
        $mansethaberlerlasts = $mansethaberlergenel->slice(23); // 20-26. öğeleri top olarak ayır

                    $view->with('mansethaberler', $mansethaberler)->with('mansethaberlerlasteight', $mansethaberlerlasteight)->with('mansethaberlerlasts', $mansethaberlerlasts);
                });


          View::composer(['home_modules.moduller'], function ($view) {

            $cityPrayer=PrayerTimes::all();
            $cityPrayertimes=PrayerTimes::where('city','LIKE','%'.config('settings.main_city').'%')->first();
      
            $cityWeathers = Weathers::all()->groupBy('city');
            $cityWeathersTimes=Weathers::where('city','LIKE','%'.config('settings.main_city').'%')->first();
            $cityWeathersNextTimes=Weathers::where('city','LIKE','%'.config('settings.main_city').'%')->offset(1)->limit(4)->get();

            $cityPharmacies=Pharmacies::all()->groupBy('city');


                    $view->with('cityPrayer', $cityPrayer)->with('cityPrayertimes', $cityPrayertimes)->with('cityWeathers', $cityWeathers)->with('cityWeathersTimes', $cityWeathersTimes)->with('cityWeathersNextTimes', $cityWeathersNextTimes)->with('cityPharmacies', $cityPharmacies);
                });


       View::composer(['layout.footer'], function ($view) {
            $menusleft=Menu::orderBy('page_order', 'asc')->where('type',1)->get();
            $menusright=Menu::orderBy('page_order', 'asc')->where('type',2)->get();
            $view->with('menusleft', $menusleft)
            ->with('menusright', $menusright);
        });

    }

}

