<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;



class News extends Model

{

    use SoftDeletes;

    use HasFactory;

    protected $fillable = [

        'category_id',

        'source_id',

        'date',

        'time',

        'color',

        'name',

        'short_description',

        'description',

        'article_id',

        'photo_gallary_id',

        'video_gallary_id',

        'author_id',

        'views_count',

        'status',

        'news_settings',

        'integration_code',

        'slug',

        'is_shared',

        'source_site',

        'original_news_id',

        'shared_at',

    ];



    public function Image(){

        return $this->hasOne(images::class,'news_id','id');

    }

    public function Tags(){

        return $this->hasOne(Tag::class,'news_id','id');

    }

    public function Category(){

        return $this->hasOne(Category::class,'id','category_id');

    }

      public function Author(){

        return $this->hasOne(Authors::class,'id','author_id');

    }

       public function PhotoGallery(){

        return $this->hasOne(PhotoGallery::class,'id','photo_gallary_id');

    }

       public function VideoGallery(){

        return $this->hasOne(Video::class,'id','video_gallary_id');

    }



}

