<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'top_category_id',
        'name',
        'icon',
        'description',
        'keywords',
        'code',
        'color',
        'status',
        'slug',
        'menu_settings',
    ];

    public function TopCategory(){
        return $this->hasOne(Category::class,'id','top_category_id');
    }
}
