<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;



class Authors extends Model

{

    use HasFactory;

    use SoftDeletes;

        public function news()
    {
        return $this->hasMany(News::class, 'author_id'); // author_id foreign key olarak kabul edilir
    }

    // Accessor to get the latest news
    public function getLastNewsAttribute()
    {
        return $this->news()->latest()->first();
    }

     public function lastNews()
    {
        return $this->hasOne(News::class, 'author_id', 'id')->latest();
    }

    
}

