<?php



namespace App\Http\Controllers;



use App\Models\images;
use App\Models\Video;

use App\Models\Link;

use App\Models\News;
use App\Models\Authors;
use App\Models\Category;

use Faker\Provider\Image;

use Illuminate\Http\Request;

use Carbon\Carbon;


class VideoController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function VideoPages()

    {
         $VideolastFirst=Video::orderBy('created_at', 'desc')->first();
        $VideolastThree=Video::orderBy('created_at', 'desc')->offset(1)->limit(4)->get();
        $VideolastEight=Video::orderBy('created_at', 'desc')->offset(5)->limit(100)->get();

         return view('video_galeries', compact(['VideolastFirst','VideolastThree','VideolastEight']));

    }


    public function Video($slug)

    {

       $video=Video::where('slug',$slug)->first();
       $category=category::where('id',$video->category_id)->first();


        $yesterday = Carbon::now()->subDay(15);
        $recentNews = Video::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(10)
                          ->get();
        $categoryhaberlerNews=Video::where('category_id',$video->category_id)->where('id','!=',$video->id)->orderBy('created_at', 'desc')->limit(6)->get();

        return view('video', compact(['video','recentNews','categoryhaberlerNews','category']));

    }


    public function AuthorsNews($yazar,$slug)
    {
       $news=News::where('slug',$slug)->first();
       $yazar=Authors::where('slug',$yazar)->first();
       $yazarlar=Authors::where('type',1)->orderBy('name', 'asc')->get();
        $yazarHaberler=News::where('author_id',$yazar->id)->orderBy('created_at', 'desc')->limit(5)->get();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();

        return view('author_news', compact(['news','recentNews','yazarlar','yazarHaberler','yazar']));

    }





    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        //

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        //

    }



    /**

     * Display the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function show(news $news)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function edit(news $news)

    {

        //

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, news $news)

    {

        //

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function destroy(news $news)

    {

        //

    }

}

