<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;
use App\Models\Authors;
use App\Models\Category;
use App\Models\News;
use App\Models\Vision;
use App\Models\Newspaper;
use App\Models\PhotoGallery;
use App\Models\Pharmacies;
use App\Models\PrayerTimes;
use App\Models\Weathers;
use App\Models\Video;
use Illuminate\Support\Facades\Response;

class SitemapController extends Controller
{
   public function index()
    {
        $sitemap = Sitemap::create();

        // Categories
        $categories = Category::all();
        foreach ($categories as $category) {
            $sitemap->add(Url::create("/kategori/{$category->slug}"));
        }

        // News
        $news = News::all();
        foreach ($news as $new) {
            $sitemap->add(Url::create("/{$new->slug}.html"));
        }

        // Photo Galleries
        $photoGalleries = PhotoGallery::all();
        foreach ($photoGalleries as $photoGallery) {
            $sitemap->add(Url::create("/foto-galeri/{$photoGallery->slug}"));
        }
        // Videos
        $videos = Video::all();
        foreach ($videos as $video) {
            $sitemap->add(Url::create("/video/{$video->slug}"));
        }

        $sitemap->writeToFile(public_path('sitemap.xml'));


        $authors = Authors::all();
        foreach ($authors as $author) {
            $sitemap->add(Url::create("/yazar/{$author->slug}"));
        }

         $visions = Vision::all();
        foreach ($visions as $vision) {
            $sitemap->add(Url::create("/vizyon/{$vision->seourl}"));
        }

         $newspapers = Newspaper::all();
        foreach ($newspapers as $newspaper) {
            $sitemap->add(Url::create("/gazete/{$newspaper->slug}"));
        }

         $pharmacies = Pharmacies::all();
        foreach ($pharmacies as $pharmacy) {
            $sitemap->add(Url::create("/nobetci-eczaneler/{$pharmacy->city}"));
        }

            $prayertimes = PrayerTimes::all();
        foreach ($prayertimes as $prayertime) {
            $sitemap->add(Url::create("/namaz-vakitleri/{$prayertime->city}"));
        }


        $weathers = Weathers::all();
        foreach ($weathers as $weather) {
            $sitemap->add(Url::create("/hava-durumu/{$weather->city}-7-gunluk"));
            $sitemap->add(Url::create("/hava-durumu/{$weather->city}-10-gunluk"));
            $sitemap->add(Url::create("/hava-durumu/{$weather->city}-15-gunluk"));
        }

        $sitemap->writeToFile(public_path('sitemap.xml'));

        return true;
    }

     public function news()
    {
        $newsItems = News::where('status', 1)->orderBy('created_at', 'desc')->take(50)->get();

        $sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
        $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"';
        $sitemap .= ' xmlns:news="http://www.google.com/schemas/sitemap-news/0.9">';

        foreach ($newsItems as $news) {
            $sitemap .= '<url>';
            $sitemap .= '<loc>' . url('/haber/' . $news->slug) . '</loc>';
            $sitemap .= '<news:news>';
            $sitemap .= '<news:publication>';
            $sitemap .= '<news:name>The Example Times</news:name>';
            $sitemap .= '<news:language>en</news:language>';
            $sitemap .= '</news:publication>';
            $sitemap .= '<news:publication_date>' . $news->created_at->format('Y-m-d') . '</news:publication_date>';
            $sitemap .= '<news:title>' . htmlspecialchars($news->name) . '</news:title>';
            $sitemap .= '</news:news>';
            $sitemap .= '</url>';
        }

        $sitemap .= '</urlset>';

        return Response::make($sitemap, 200)->header('Content-Type', 'application/xml');
    }
}
