<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use App\Models\News;
use App\Models\Setting;

class RssController extends Controller
{
     public function news()
    {

        $title=Setting::where('id',1)->first();
        $description=Setting::where('id',2)->first();


        $newsItems = News::where('status', 1)->orderBy('created_at', 'desc')->take(50)->get();

        $rssFeed = '<?xml version="1.0" encoding="UTF-8" ?>';
        $rssFeed .= '<rss version="2.0">';
        $rssFeed .= '<channel>';
        $rssFeed .= '<title>'.$title->name.'</title>';
        $rssFeed .= '<link>' . url('/') . '</link>';
        $rssFeed .= '<description>'.$title->description.'</description>';
        $rssFeed .= '<language>tr-tr</language>';

        foreach ($newsItems as $news) {
            $rssFeed .= '<item>';
            $rssFeed .= '<title>' . htmlspecialchars($news->name, ENT_XML1, 'UTF-8') . '</title>';
            $rssFeed .= '<link>' . url('/news/' . $news->slug) . '</link>';
            $rssFeed .= '<description>' . htmlspecialchars($news->short_description, ENT_XML1, 'UTF-8') . '</description>';
            $rssFeed .= '<pubDate>' . $news->created_at->toRssString() . '</pubDate>';
            $rssFeed .= '<guid>' . url('/news/' . $news->slug) . '</guid>';
            $rssFeed .= '</item>';
        }

        $rssFeed .= '</channel>';
        $rssFeed .= '</rss>';

        return Response::make($rssFeed, 200)->header('Content-Type', 'application/rss+xml');
    }
}
