<?php



namespace App\Http\Controllers;



use App\Models\images;
use App\Models\PhotoGallery;

use App\Models\PhotoGalleryImage;

use App\Models\Link;

use App\Models\News;
use App\Models\Authors;
use App\Models\Category;

use Faker\Provider\Image;

use Illuminate\Http\Request;

use Carbon\Carbon;


class PhotoGalleryController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function PhotoGalleryPages()

    {

         $PhotoGallerylastFirst=PhotoGallery::orderBy('created_at', 'desc')->first();
        $PhotoGallerylastEight=PhotoGallery::orderBy('created_at', 'desc')->offset(1)->limit(8)->get();

         return view('photo_galeries', compact(['PhotoGallerylastFirst','PhotoGallerylastEight']));

    }



    public function PhotoGallery($slug)

    {

       $PhotoGallery=PhotoGallery::where('slug',$slug)->first();
       $PhotoGalleryImagesCount=PhotoGalleryImage::where('gallery_id',$PhotoGallery->id)->count();
       $currentpage=1;

       $PhotoGalleryImages=PhotoGalleryImage::where('gallery_id',$PhotoGallery->id)->first();
       $category=category::where('id',$PhotoGallery->category_id)->first();


        $yesterday = Carbon::now()->subDay(15);
        $recentNews = PhotoGallery::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=PhotoGallery::where('category_id',$PhotoGallery->category_id)->where('id','!=',$PhotoGallery->id)->orderBy('created_at', 'desc')->limit(6)->get();

        return view('photo_gallery', compact(['PhotoGallery','PhotoGalleryImages','recentNews','categoryhaberlerNews','category','PhotoGalleryImagesCount','currentpage']));

    }

        public function PhotoGalleryPage($slug,$page)

    {

       $PhotoGallery=PhotoGallery::where('slug',$slug)->first();
       if ($page=='') {
       $PhotoGalleryImages=PhotoGalleryImage::where('gallery_id',$PhotoGallery->id)->first();
       }else{
       $PhotoGalleryImages=PhotoGalleryImage::where('gallery_id',$PhotoGallery->id)->offset(($page-1))->first();
       } 
       $PhotoGalleryImagesCount=PhotoGalleryImage::where('gallery_id',$PhotoGallery->id)->count();
       $currentpage=$page;

       $category=category::where('id',$PhotoGallery->category_id)->first();


        $yesterday = Carbon::now()->subDay();
        $recentNews = PhotoGallery::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=PhotoGallery::where('category_id',$PhotoGallery->category_id)->where('id','!=',$PhotoGallery->id)->orderBy('created_at', 'desc')->limit(6)->get();

        return view('photo_gallery', compact(['PhotoGallery','PhotoGalleryImages','recentNews','categoryhaberlerNews','category','PhotoGalleryImagesCount','currentpage']));

    }


    public function AuthorsNews($yazar,$slug)
    {
       $news=News::where('slug',$slug)->first();
       $yazar=Authors::where('slug',$yazar)->first();
       $yazarlar=Authors::where('type',1)->orderBy('name', 'asc')->get();
        $yazarHaberler=News::where('author_id',$yazar->id)->orderBy('created_at', 'desc')->limit(5)->get();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();

        return view('author_news', compact(['news','recentNews','yazarlar','yazarHaberler','yazar']));

    }





    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        //

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        //

    }



    /**

     * Display the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function show(news $news)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function edit(news $news)

    {

        //

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, news $news)

    {

        //

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function destroy(news $news)

    {

        //

    }

}

