<?php



namespace App\Http\Controllers;



use App\Models\images;

use App\Models\Link;

use App\Models\News;
use App\Models\Page;
use App\Models\Authors;
use App\Models\Category;

use Faker\Provider\Image;

use Illuminate\Http\Request;

use Carbon\Carbon;


class PageController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function page($page)

    {

      $page=Page::where('slug',$page)->first();

      return view('page',compact(['page']));


    }

       public function pageIletisim()

    {

      return view('iletisim');


    }


    public function pageSecurity()

    {

      return view('gizlilik');


    }




    public function News($slug)

    {

       $news=News::where('slug',$slug)->first();
       $newscount = $news->views_count ?? 0;
        $newsUpdate=News::where('id',$news->id)->update(['views_count'=>($newscount+1)]);

       $category=category::where('id',$news->category_id)->first();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=News::where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->limit(6)->get();

        return view('news', compact(['news','recentNews','categoryhaberlerNews','category']));

    }


    public function AuthorsNews($yazar,$slug)
    {
       $news=News::where('slug',$slug)->first();
       $yazar=Authors::where('slug',$yazar)->first();
       $yazarlar=Authors::where('type',1)->orderBy('name', 'asc')->get();
        $yazarHaberler=News::where('author_id',$yazar->id)->orderBy('created_at', 'desc')->limit(5)->get();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();

        return view('author_news', compact(['news','recentNews','yazarlar','yazarHaberler','yazar']));

    }





    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        //

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        //

    }



    /**

     * Display the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function show(news $news)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function edit(news $news)

    {

        //

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, news $news)

    {

        //

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function destroy(news $news)

    {

        //

    }

}

