<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Link;
use App\Models\News;
use Illuminate\Http\Request;

class NewsWidgetController extends Controller
{

    public function NewsPage()
    {

        $News=News::where('status',1)->orderBy('id','desc')->paginate(50);
        $HomeMenus=Link::orderBy('order','asc')->get();

        return view('newsPage', compact(['News','HomeMenus']));

    }


    public function NewsMostRead($paginate,$category=NULL)
    {
        if($category==NULL) {
            $News = News::where('status',1)->orderBy('views_count', 'desc')->paginate($paginate);
        }else{
            $News = News::where('status',1)->orderBy('views_count', 'desc')->where('category_id',$category)->paginate($paginate);

        }
        return $News;

    }

    public function NewsCategory($category,$paginate)
    {

        $News=News::where('status',1)->where('category_id',$category)->orderBy('views_count','desc')->paginate($paginate);
        return $News;

    }

}
