<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use App\Models\NewsEmoji;
use Illuminate\Http\Request;

class NewsEmojiController  extends Controller
{
public function updateEmoji(Request $request)
{
    $request->validate([
        'news_id' => 'required|integer|exists:news,id',
        'type' => 'required|integer|min:1|max:6',
    ]);

    $ip = $request->ip();
    $newsId = $request->input('news_id');
    $type = $request->input('type');

    // Mevcut tepkiyi kontrol et
    $existingReaction = NewsEmoji::where('news_id', $newsId)
                                 ->where('ip', $ip)
                                 ->first();

    if ($existingReaction) {
        $existingReaction->update(['type' => $type]);
    } else {
        NewsEmoji::create([
            'news_id' => $newsId,
            'type' => $type,
            'ip' => $ip,
        ]);
    }

    // Her emoji türü için sayımı al
    $reactions = NewsEmoji::where('news_id', $newsId)
                          ->selectRaw('type, COUNT(*) as count')
                          ->groupBy('type')
                          ->get();

    return response()->json($reactions); // JSON formatında geri döndür
}
}
