<?php



namespace App\Http\Controllers;



use App\Models\images;

use App\Models\Link;

use App\Models\News;
use App\Models\Authors;
use App\Models\NewsEmoji;
use App\Models\NewsComment;
use App\Models\Category;

use Faker\Provider\Image;

use Illuminate\Http\Request;

use Carbon\Carbon;
use App\Models\Newspaper;


class NewsController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function Authors()

    {

        $authors=Authors::where('type',1)->orderBy('code', 'asc')->get();

        $ekonomikhaberlerSlider=News::where('status',1)->where('category_id',12)->orderBy('created_at', 'desc')->limit(1)->get();
        $ekonomikhaberlerNews=News::where('status',1)->where('category_id',12)->orderBy('created_at', 'desc')->offset(1)->limit(5)->get();

        $bursahaberlerSlider=News::where('status',1)->where('category_id',3)->orderBy('created_at', 'desc')->limit(1)->get();
        $bursahaberlerNews=News::where('status',1)->where('category_id',3)->orderBy('created_at', 'desc')->offset(1)->limit(5)->get();

        $guncelhaberlerSlider=News::where('status',1)->where('category_id',4)->orderBy('created_at', 'desc')->limit(1)->get();
        $guncelhaberlerNews=News::where('status',1)->where('category_id',4)->orderBy('created_at', 'desc')->offset(1)->limit(5)->get();
        return view('authors', compact(['authors','ekonomikhaberlerSlider','ekonomikhaberlerNews','bursahaberlerSlider','bursahaberlerNews','guncelhaberlerSlider','guncelhaberlerNews']));
   

    }



    public function News($slug)

    {

       $news=News::where('slug',$slug)->first();
       $newscount = $news->views_count ?? 0;
        $newsUpdate=News::where('id',$news->id)->update(['views_count'=>($newscount+1)]);

       $category=category::where('id',$news->category_id)->first();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('status',1)->where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->limit(6)->get();
        $categoryhaberlerTop=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->offset(6)->limit(10)->get();

           $emojiCounts = NewsEmoji::where('news_id', $news->id)
        ->selectRaw('type, COUNT(*) as count')
        ->groupBy('type')
        ->pluck('count', 'type')
        ->toArray();


 $comments = NewsComment::where('news_id',  $news->id)
                                ->withCount(['likes as like_count' => function ($query) {
                                    $query->where('type', 1);
                                }, 'likes as dislike_count' => function ($query) {
                                    $query->where('type', 0);
                                }])
                                ->get();

        return view('news', compact(['news','recentNews','categoryhaberlerNews','category','categoryhaberlerTop','emojiCounts','comments']));

    }

     public function NewsAmp($slug)

    {

       $news=News::where('slug',$slug)->first();
       $newscount = $news->views_count ?? 0;
        $newsUpdate=News::where('id',$news->id)->update(['views_count'=>($newscount+1)]);

       $category=category::where('id',$news->category_id)->first();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('status',1)->where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->limit(6)->get();
        $categoryhaberlerTop=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->offset(6)->limit(10)->get();

           $emojiCounts = NewsEmoji::where('news_id', $news->id)
        ->selectRaw('type, COUNT(*) as count')
        ->groupBy('type')
        ->pluck('count', 'type')
        ->toArray();


 $comments = NewsComment::where('news_id',  $news->id)
                                ->withCount(['likes as like_count' => function ($query) {
                                    $query->where('type', 1);
                                }, 'likes as dislike_count' => function ($query) {
                                    $query->where('type', 0);
                                }])
                                ->get();

        return view('amp', compact(['news','recentNews','categoryhaberlerNews','category','categoryhaberlerTop','emojiCounts','comments']));

    }


    public function AuthorsNews($yazar,$slug)
    {
       $news=News::where('slug',$slug)->first();
       $yazar=Authors::where('slug',$yazar)->first();
       $yazarlar=Authors::where('type',1)->orderBy('name', 'asc')->get();
        $yazarHaberler=News::where('status',1)->where('author_id',$yazar->id)->orderBy('created_at', 'desc')->limit(5)->get();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('status',1)->where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
 $emojiCounts = NewsEmoji::where('news_id', $news->id)
        ->selectRaw('type, COUNT(*) as count')
        ->groupBy('type')
        ->pluck('count', 'type')
        ->toArray();


 $comments = NewsComment::where('news_id',  $news->id)
                                ->withCount(['likes as like_count' => function ($query) {
                                    $query->where('type', 1);
                                }, 'likes as dislike_count' => function ($query) {
                                    $query->where('type', 0);
                                }])
                                ->get();
        return view('author_news', compact(['news','recentNews','yazarlar','yazarHaberler','yazar','emojiCounts','comments']));

    }

     public function authorNewsFull($yazar)
    {
       $yazar=Authors::where('slug',$yazar)->first();
        $ekonomikhaberlerNews=News::where('status',1)->where('author_id',$yazar->id)->orderBy('created_at', 'desc')->limit(20)->get();

        return view('news_author', compact(['ekonomikhaberlerNews','yazar']));

    }

      public function Gazete($slug)
    {
       $newspaper=Newspaper::where('slug',$slug)->first();
       $newspapers=Newspaper::orderBy('title','asc')->get();

        return view('newspaper', compact(['newspaper','newspapers']));

    }





    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        //

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        //

    }



    /**

     * Display the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function show(news $news)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function edit(news $news)

    {

        //

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, news $news)

    {

        //

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  \App\Models\news  $news

     * @return \Illuminate\Http\Response

     */

    public function destroy(news $news)

    {

        //

    }

     public function searchNews(Request $request){

            $q=$request->q;
            
            if(isset($q)){
            $ekonomikhaberlerNews=News::where('status',1)->where('name','LIKE', '%'.$request->q.'%')->orWhere('description','LIKE', '%'.$request->q.'%')->orderBy('created_at', 'desc')->limit(50)->get();
                        return view('search', compact(['ekonomikhaberlerNews','q']));

        }else{
                                    return view('search', compact(['q']));

        }


    }
    


    public function getNextNews($id)
{
     $news = News::where('id', '>', $id)->orderBy('id')->first();

       $newscount = $news->views_count ?? 0;
        $newsUpdate=News::where('id',$news->id)->update(['views_count'=>($newscount+1)]);

       $category=category::where('id',$news->category_id)->first();


        $yesterday = Carbon::now()->subDay();
        $recentNews = News::where('status',1)->where('created_at', '>', $yesterday)
                          ->inRandomOrder()
                          ->take(5)
                          ->get();
        $categoryhaberlerNews=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->limit(6)->get();
        $categoryhaberlerTop=News::where('status',1)->where('category_id',$news->category_id)->where('id','!=',$news->id)->orderBy('created_at', 'desc')->offset(6)->limit(10)->get();

    if (!$news) {
        return response()->json(['message' => 'No more news'], 404);
    }

    $view = view('news_more', compact(['news','recentNews','categoryhaberlerNews','category','categoryhaberlerTop']))->render();

    return response()->json([
        'html' => $view,
        'next_id' => $news->id,
        'slug' => $news->slug,
        'name' => $news->name,
    ]);
}


}

