<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use App\Models\NewsComment;
use App\Models\NewsCommentsLike;
use Illuminate\Http\Request;

class NewsCommentController  extends Controller
{
   public function fetchComments($newsId)
    {
        $comments = NewsComment::where('news_id', $newsId)
                                ->where('status', 1) // Onaylanmış yorumlar
                                ->withCount(['likes as like_count' => function ($query) {
                                    $query->where('type', 1);
                                }, 'likes as dislike_count' => function ($query) {
                                    $query->where('type', 0);
                                }])
                                ->get();

        return response()->json($comments);
    }

    // Yorum ekle
    public function addComment(Request $request)
    {
        $request->validate([
            'news_id' => 'required|integer',
            'name' => 'required|string|max:255',
            'mail' => 'required|email',
            'comment' => 'required|string'
        ]);

        NewsComment::create([
            'news_id' => $request->input('news_id'),
            'name' => $request->input('name'),
            'mail' => $request->input('mail'),
            'comment' => $request->input('comment'),
            'status' => 0, // Onay bekliyor
            'ip' => $request->ip()
        ]);

        return response()->json(['message' => 'Yorum Başarı Eklendi. Yönetici Onayı Bekleniyor.']);
    }

    // Beğenme veya dislike işlemi
    public function toggleLike(Request $request)
    {
       

          $ip = $request->ip();
    $commentId = $request->input('comment_id');
    $type = $request->input('type');

    // Yorum için mevcut beğeni/dislike kontrolü
    $like = NewsCommentsLike::where('comment_id', $commentId)
                            ->where('ip', $ip)
                            ->first();

    if ($like) {
        // Mevcut beğeni/dislike güncelle
        $like->update(['type' => $type]);
    } else {
        // Yeni bir beğeni/dislike ekle
        NewsCommentsLike::create([
            'comment_id' => $commentId,
            'type' => $type,
            'ip' => $ip
        ]);
    }

    // Yorum için toplam beğeni ve dislike sayısını al
    $likeCount = NewsCommentsLike::where('comment_id', $commentId)->where('type', 1)->count();
    $dislikeCount = NewsCommentsLike::where('comment_id', $commentId)->where('type', 0)->count();

    return response()->json([
        'like_count' => $likeCount,
        'dislike_count' => $dislikeCount,
        'message' => 'İşlem başarıyla tamamlandı.'
    ]);
    }
}
