<?php



namespace App\Http\Controllers;



use App\Models\Category;

use App\Models\Pharmacies;
use App\Models\Vision;
use App\Models\Weathers;
use App\Models\PrayerTimes;
use App\Models\OfficialNews;

use App\Models\News;

use Illuminate\Http\Request;
use App\Models\Exchange;
use Carbon\Carbon;



class ModulController extends Controller

{

    public function GetPharmacies($city){

           $pharmacies = Pharmacies::where('city', $city)->get();

         return view('modul.pharmaci', compact(['pharmacies','city']));
    }

      public function GetOfficial($slug){


         $official = OfficialNews::where('slug', $slug)->first();

         return view('modul.official', compact(['official']));
    }

         public function GetVision($slug){

         $vision = Vision::where('seourl', $slug)->first();

         return view('modul.vision', compact(['vision']));
    }


         public function FullVisions(){

         $visions = Vision::orderBy('created_at', 'desc')->get();

         return view('modul.visions', compact(['visions']));
    }

       public function FullPharmacies(){

         $cityPharmacies=Pharmacies::all()->groupBy('city');

         return view('modul.pharmacies', compact(['cityPharmacies']));

    } public function FullOfficial(Request $request){
            $date = $request->date 
        ? Carbon::createFromFormat('Y-m-d', $request->date)->format('d.m.Y') 
        : Carbon::now()->format('d.m.Y');

    // Sorguyu oluştur
    $officialNews = OfficialNews::where('date', $date)
        ->orderBy('id', 'desc')
        ->get();

         return view('modul.officials', compact(['officialNews']));
    }

         public function FullWeathers(){

         $cityPharmacies=Weathers::all()->groupBy('city');

         return view('modul.weathers', compact(['cityPharmacies']));
    }

         public function FullPrayer(){

         $cityPharmacies=PrayerTimes::all()->groupBy('city');

         return view('modul.prayers', compact(['cityPharmacies']));
    }

      public function getWeather15($city){
           $day=15;
           $weathers = Weathers::where('city', $city)->limit($day)->get();
         return view('modul.weather', compact(['weathers','city','day']));
    }

       public function getWeather10($city){
           $day=10;
           $weathers = Weathers::where('city', $city)->limit($day)->get();
         return view('modul.weather', compact(['weathers','city','day']));
    }

       public function getWeather7($city){
           $day=7;
           $weathers = Weathers::where('city', $city)->limit($day)->get();
         return view('modul.weather', compact(['weathers','city','day']));
    }

      public function GetPrayer($city){

           $prayer = PrayerTimes::where('city', $city)->first();
            $cityPharmacies=PrayerTimes::all()->groupBy('city');

         return view('modul.prayer', compact(['prayer','city','cityPharmacies']));
    }




}

