<?php

namespace App\Http\Controllers;

use App\Models\Horoscope;
use Illuminate\Http\Request;
use Carbon\Carbon;

class HoroscopeController extends Controller
{

     public function getHoroscope(Request $request)
    {
        $sign = $request->input('sign');
        $date = Carbon::now()->toDateString();

        // İlgili burcun son yorumunu al
        $horoscope = Horoscope::where('sign', $sign)
                              ->where('date', $date)
                              ->first();

        if ($horoscope) {
            return response()->json(['content' => $horoscope->content]);
        } else {
            return response()->json(['content' => 'Bu burç için bugün henüz yorum bulunmamaktadır.']);
        }
    }

}
