<?php



namespace App\Http\Controllers;



use App\Models\Category;

use App\Models\News;
use App\Models\Newspaper;
use App\Models\Vision;
use App\Models\Video;
use App\Models\HomepageLayout;
use App\Models\PrayerTimes;
use App\Models\PhotoGallery;
use App\Models\Authors;
use App\Models\Exchange;
use App\Models\Setting;
use Illuminate\Http\Request;
use League\Flysystem\Config;



class HomepageController extends Controller

{



    public function index()

    {
         $layout = HomepageLayout::first();

           $viewData = [
            'layout' => $layout,
        ];


        if (config('settings.topheadline_type') == 1) {
         $viewData['topheadlines'] = News::where('status',1)->where('is_topheadline','1')->orderBy('created_at', 'desc')->limit(3)->get();
        }
        if (config('settings.topheadline_type') == 2) {
         $viewData['topheadlines'] = News::where('status',1)->where('is_topheadline','1')->orderBy('created_at', 'desc')->limit(4)->get();
        }
        if (config('settings.topheadline_type') == 3) {
         $viewData['topheadlines'] = News::where('status',1)->where('is_topheadline','1')->orderBy('created_at', 'desc')->limit(5)->get();
        }
        if (config('settings.topheadline_type') == 4) {
         $viewData['topheadlines'] = News::where('status',1)->where('is_topheadline','1')->orderBy('created_at', 'desc')->limit(2)->get();
        }

        // if koşulu ile yazarlar verisini ekleme
        if (config('settings.authors_status') == 1) {
            $viewData['yazarlar'] = Authors::where('type', 1)->orderBy('code', 'asc')->get();
        }
          if (config('settings.vision_status') == 1) {
            $viewData['visions'] = Vision::inRandomOrder()->take(10)->get();
        }
          if (config('settings.newspaper_status') == 1) {
            $viewData['newspapers'] = Newspaper::orderBy('title','asc')->get();
        }



        // Veriyi view ile döndürme
        return view('homepage', $viewData);




    }

public function getPrayerTimes($city)
{
    $cityPrayertimes = PrayerTimes::where('city', $city)->first();

    if (!$cityPrayertimes) {
        return response()->json(['error' => 'City not found'], 404);
    }

    // Şu anki saat
    $currentTime = now();

    // Kalan süreyi hesaplama
    $nextTime = $this->calculateNextTime($cityPrayertimes, $currentTime);

    return response()->json([
        'times' => [
            'imsak' => $cityPrayertimes->imsak,
            'sun' => $cityPrayertimes->sun,
            'noon' => $cityPrayertimes->noon,
            'afternoon' => $cityPrayertimes->afternoon,
            'evening' => $cityPrayertimes->evening,
            'isha' => $cityPrayertimes->isha,
        ],
        'remainingTime' => $nextTime
    ]);
}

private function calculateNextTime($times, $currentTime)
{
    $timesArray = [
        'imsak' => $times->imsak,
        'sun' => $times->sun,
        'noon' => $times->noon,
        'afternoon' => $times->afternoon,
        'evening' => $times->evening,
        'isha' => $times->isha,
    ];

    foreach ($timesArray as $name => $time) {
        $prayerTime = \Carbon\Carbon::parse($time);
        if ($currentTime->lessThan($prayerTime)) {
            $remaining = $currentTime->diff($prayerTime);
            return $remaining->format('%H:%I:%S');
        }
    }

    return '00:00:00'; // Tüm vakitler geçtiyse
}


public function getWeather($city)
{
    // O günün hava durumu bilgisi
    $currentWeather = Weathers::where('city', $city)
        ->first();

    // Sonraki 4 günün tahmini
    $forecast = Weathers::where('city', $city)
        ->offset(1)
        ->limit(4)
        ->get();

    // JSON formatında döndür
    return response()->json([
        'current' => [
            'day' => $currentWeather->day,
            'image' => $currentWeather->image,
            'status' => $currentWeather->status,
        ],
        'forecast' => $forecast->map(function ($weather) {
            return [
                'date' => convertDate($weather->date),
                'day' => $weather->day,
                'image' => $weather->image,
            ];
        })
    ]);
}


}

