<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\News;
use App\Models\Video;
use App\Models\PhotoGallery;
use App\Models\Authors;
use App\Models\Exchange;
use App\Models\Setting;


class AuthorController extends BaseController
{
    public $successStatus = 200;

    public function getAuthors(Request $request){
      $yazarlar = Authors::where('type', 1)
        ->orderBy('code', 'asc')
        ->limit($request->limit ?? 5)
        ->offset($request->offset ?? 0)
        ->with(['lastNews' => function ($query) {
            $query->latest('created_at');
        }])
        ->get();

    return $this->sendResponse($yazarlar);
    }

        public function getAuthorsNews($author_id,Request $request){
       $yazarHaberler=News::where('author_id',$author_id)->orderBy('created_at', 'desc')->limit($request->limit ?? 5)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($yazarHaberler);
    }

    



}
