<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\NewsSyncService;

class SyncNewsFromMainSite extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'news:sync-from-main';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync news from main site to this sub site';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting news sync from main site...');

        $syncService = new \App\Services\NewsSyncService();
        $result = $syncService->syncFromMainSite();

        if ($result) {
            $this->info('News sync completed successfully!');
        } else {
            $this->error('News sync failed! Check logs for details.');
        }

        return $result ? 0 : 1;
    }
}
