<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Weathers;
use Carbon\Carbon;

class GetWeathers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Weathers';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Hava Durumu Verilerini Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {


        Weathers::truncate();

        setlocale(LC_TIME, 'tr_TR.UTF-8');
        $site="https://havadurumu15gunluk.xyz/turkiye-hava-durumu.html";



        $baglan=file_get_contents($site);


        $illist=explode('<ul class="list1">',$baglan);
        $illist=explode('</ul>',$illist[1]);



        $ilgenel=explode('<li>',$illist[0]);
        $ilsay=count($ilgenel)-1;

        for($i=1;$i<=$ilsay; $i++){
        $ilgenel=explode('<li>',$illist[0]);
        $ilgenel=explode('</li>',$ilgenel[$i]);


    
        $illink=explode('<a href="',$ilgenel[0]);
        $illink=explode('"',$illink[1]);

        $il=explode('">',$ilgenel[0]);
        $il=explode('<',$il[1]);

        $ilbaglan=file_get_contents("https://havadurumu15gunluk.xyz/".$illink[0]);


        

        $havadurumutable=explode('<table>',$ilbaglan);
        $havadurumutable=explode('</table>',$havadurumutable[1]);


        $havatek=explode('<tr>',$havadurumutable[0]);
        $trsay=count($havatek)-1;
        for($a=2;$a<=$trsay;$a++){
        $havatek=explode('<tr>',$havadurumutable[0]);      
        $havatek=explode('</tr>',$havatek[$a]);

       


        $tabletd=explode('<td',$havatek[0]);
        $day=explode('</td>',$tabletd[1]);

        $day[0]=str_replace('> ', '', $day[0]);


        if(ltrim(rtrim($day[0]))=="Bugün"){

        $date = date('Y-m-d');

        // Türkçe ay ve gün isimlerini tanımla
        $days = ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt'];
        $months = ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'];

        // Tarihi parçalara ayır
        $timestamp = strtotime($date);
        $dayIndex = date('w', $timestamp); // Gün indexi (0 = Paz)
        $monthIndex = date('n', $timestamp) - 1; // Ay indexi (1 = Oca)
        $daya = date('d', $timestamp); // Gün
        $year = date('Y', $timestamp); // Yıl

        // Formatla
        $day[0]=$daya . ' ' . $months[$monthIndex] . ' ' . $days[$dayIndex];

        }
        if(ltrim(rtrim($day[0]))=="Yarın"){

        $date = date('Y-m-d', strtotime(date('Y-m-d') . ' +1 day'));

        // Türkçe ay ve gün isimlerini tanımla
        $days = ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt'];
        $months = ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'];

        // Tarihi parçalara ayır
        $timestamp = strtotime($date);
        $dayIndex = date('w', $timestamp); // Gün indexi (0 = Paz)
        $monthIndex = date('n', $timestamp) - 1; // Ay indexi (1 = Oca)
        $daya = date('d', $timestamp); // Gün
        $year = date('Y', $timestamp); // Yıl

        // Formatla
        $day[0]=$daya . ' ' . $months[$monthIndex] . ' ' . $days[$dayIndex];

        }

        $image=explode('src="',$havatek[0]);
        $image=explode('"',$image[1]);
      
        $havastatus=explode('title="',$havatek[0]);
        $havastatus=explode('"',$havastatus[1]);
       
        @$havaday=explode('</td>',$tabletd[4]);
        @$havanight=explode('</td>',$tabletd[5]);

        $havaday[0]=str_replace('class="notranslate">', '', $havaday[0]);
        $havanight[0]=str_replace('class="notranslate">', '', $havaday[0]);
        $havaday[0]=str_replace('</td>', '', $havaday[0]);
        $havanight[0]=str_replace('</td>', '', $havanight[0]);
        $day[0]=str_replace('>', '', $day[0]);

        $Weathers= New Weathers();
        $Weathers->city=$il[0];
        $Weathers->date=$day[0];
        $Weathers->status=$havastatus[0];
        $Weathers->image=$image[0];
        $Weathers->day=$havaday[0];
        $Weathers->night=$havanight[0];
        $Weathers->save();
      }
    }

        return Command::SUCCESS;
    }

}
