<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Horoscope;
use Carbon\Carbon;

class GetWeather extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Weather';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Hava Durumu Verilerini Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

      
      $site="https://tr.meteocast.net/extended-forecast/tr/".config('settings.main_city')."/";
      $connect=file_get_contents($site);


      $havaimage=explode('<td class="t0"><img src="',$connect);
      $havaimage=explode('"',$havaimage[1]);

      $havaimage[0]='https://tr.meteocast.net/'.$havaimage[0];

      $havaderece=explode('<h5>Sıcaklık:</h5>',$connect);
      $havaderece=explode('</b>',$havaderece[1]);

      $havaderece[0]=str_replace('<b>', '', $havaderece[0]);
      $havaderece[0]=str_replace('+', '', $havaderece[0]);
      $havaderece[0]=str_replace('&nbsp;', '', $havaderece[0]);
      $havaderece[0]= ltrim(rtrim(trim($havaderece[0])));
      $Setting=Setting::where('key','weather_image')->update(['value'=>$havaimage[0]]);
      $Setting=Setting::where('key','weather_degree')->update(['value'=>$havaderece[0]]);

        return Command::SUCCESS;
    }

}
