<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Vision;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class GetVision extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Vision';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Vizyon Sayfalarını Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {



      $directory = public_path('uploads/visions');

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.biletinial.com/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'grant_type=password&username=harunbudunapi%40biletinial.com&password=ac0ca4866e4ad854e4382f853cb139a9012b91313d005b08f4cae6de8f31fa27',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $tokenparcala=explode('{"access_token":"',$response);
        $tokenparcala=explode('"',$tokenparcala[1]);
      
      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.biletinial.com/api/movie/vision',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'Authorization: Bearer '.$tokenparcala[0].''),
      ));

      $response = curl_exec($curl);

      curl_close($curl);
    $films = json_decode($response, true);

    // Dizi içindeki film bilgilerini döngü ile işleme
    foreach ($films as $film) {
        echo "<h2>" . $film['Name'] . "</h2>";
        echo "<p><strong>Film Türleri:</strong> " . $film['FilmTypes'] . "</p>";
        echo "<p><strong>Vizyon Tarihi:</strong> " . date("d-m-Y", strtotime($film['VisionDate'])) . "</p>";
        
        // Fragman linki varsa ekle
        if (!empty($film['FragmanEmbed'])) {
            echo "<p><a href='" . $film['FragmanEmbed'] . "' target='_blank'>Fragmanı İzle</a></p>";
        }
        
        // SmartMarkers varsa göster
        if (!empty($film['SmartMarkers'])) {
            echo "<p><strong>Smart Markers:</strong></p><ul>";
            foreach ($film['SmartMarkers'] as $marker) {
                echo "<li>" . $marker['Name'] . ": " . $marker['Description'] . "</li>";
            }
            echo "</ul>";
        }
        
        echo $film['ImageUrl']."<hr>";

      $fileName = basename($film['ImageUrl']); // URL'den dosya adını alır (ör: aksam-2024-11-11-u2l2.jpg)
      $destinationPath = public_path("uploads/visions/{$fileName}"); // Hedef dizini oluşturur

      // Dosyayı URL'den indirip doğrudan public/uploads/newspaper dizinine kaydediyoruz
      file_put_contents($destinationPath, file_get_contents($film['ImageUrl']));



      $VisionCount=Vision::where('seourl',$film['SeoUrl'])->count();
      
      if($VisionCount==0){


        $site=file_get_contents('https://biletinial.com/tr-tr/sinema/'.$film['SeoUrl']);

        @$filmturu=explode('<strong>Film Türü</strong>',$site);
        @$filmturu=explode('</span>',$filmturu[1]);
        @$filmturu[0]=ltrim(rtrim($filmturu[0]));
        @$filmturu[0]=str_replace('<span>', '', $filmturu[0]);

        @$yonetmen=explode(' "directors": [',$site);
        @$yonetmen=explode(']',$yonetmen[1]);
        @$yonetmen[0]=str_replace('"', '', $yonetmen[0]);

        @$artists=explode('"artists": [',$site);
        @$artists=explode(']',$artists[1]);
        @$artists[0]=str_replace('"', '', $artists[0]);


        @$visiondate=explode('<strong>Vizyon Tarihi</strong>',$site);
        @$visiondate=explode('</span>',$visiondate[1]);
        @$visiondate[0]=ltrim(rtrim($visiondate[0]));
        @$visiondate[0]=str_replace('<span>', '', $visiondate[0]);

        @$time=explode('<strong>Süre</strong>',$site);
        @$time=explode('</span>',$time[1]);
        @$time[0]=ltrim(rtrim($time[0]));
        @$time[0]=str_replace('<span>', '', $time[0]);

        $cover=explode('style="background-image: url(',$site);
        $cover=explode(')',$cover[1]);

        @$description=explode('"description": "',$site);
        @$description=explode('"',$description[1]);
        @$description[0]=str_replace('"', '', $description[0]);

          $newVision=new Vision();
          $newVision->seourl=$film['SeoUrl'];
          $newVision->title=($film['Name']);
          $newVision->image=($fileName);
          $newVision->fragman=($film['FragmanEmbed']);
          $newVision->type=$filmturu[0] ?? '';
          $newVision->director=$yonetmen[0] ?? '';
          $newVision->description=$description[0] ?? '';
          $newVision->players=$artists[0] ?? '';
          $newVision->time=$time[0] ?? '';
          $newVision->vision_date=$visiondate[0] ?? '';
          $newVision->cover=$cover[0] ?? '';
          $newVision->save();

      }

    }
    




      

        return Command::SUCCESS;
    }

}
