<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\PrayerTimes;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class GetPrayerTimes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:PrayerTimes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Namaz Vakitlerini Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

      PrayerTimes::truncate();

      $site="https://www.haberturk.com/namaz-vakitleri";

      $baglan=file_get_contents($site);

      $geneltable=explode('<div class="overflow-x-auto mb-5"> <table class="w-full">',$baglan);
      $geneltable=explode('</table>',$geneltable[1]);

      $citytr=explode('<tr class="">',$geneltable[0]);
      $citycount=count($citytr)-1;

      for($i=1;$i<=$citycount;$i++){
        $citytr=explode('<tr class="">',$geneltable[0]);
        $citytr=explode('</tr>',$citytr[$i]);

        $city=explode('<td class="text-sm py-2.5 px-5 border-r border-b dark:border-gray-800 bg-white dark:bg-gray-900 whitespace-nowrap">',$citytr[0]);
        $city=explode('</td>',$city[1]);

        $vakit=explode('<td class="text-sm py-2.5 px-5 border-r border-b dark:border-gray-800">',$citytr[0]);
        $imsak=explode('</td>',$vakit[1]);
        $sun=explode('</td>',$vakit[2]);
        $noon=explode('</td>',$vakit[3]);
        $afternoon=explode('</td>',$vakit[4]);
        $evening=explode('</td>',$vakit[5]);
        $isha=explode('</td>',$vakit[6]);

        $prayer= new PrayerTimes();
        $prayer->city=mb_convert_case(ltrim(rtrim($city[0])), MB_CASE_TITLE, "UTF-8");
        $prayer->imsak=$imsak[0];
        $prayer->sun=$sun[0];
        $prayer->noon=$noon[0];
        $prayer->afternoon=$afternoon[0];
        $prayer->evening=$evening[0];
        $prayer->isha=$isha[0];
        $prayer->date=date('d.m.Y');
        $prayer->save();
      }

        return Command::SUCCESS;
    }

}
