<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Pharmacies;
use Carbon\Carbon;

class GetPharmacies extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Pharmacies';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Eczane Verilerini Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {


        Pharmacies::truncate();

        setlocale(LC_TIME, 'tr_TR.UTF-8');
       
       // Şehir listesini tanımla
$cities = [
    'Adana',
    'Adıyaman',
    'Afyonkarahisar',
    'Ağrı',
    'Amasya',
    'Ankara',
    'Antalya',
    'Artvin',
    'Aydın',
    'Balıkesir',
    'Bilecik',
    'Bingöl',
    'Bitlis',
    'Bolu',
    'Burdur',
    'Bursa',
    'Çanakkale',
    'Çankırı',
    'Çorum',
    'Denizli',
    'Diyarbakır',
    'Edirne',
    'Elazığ',
    'Erzincan',
    'Erzurum',
    'Eskişehir',
    'Gaziantep',
    'Giresun',
    'Gümüşhane',
    'Hakkari',
    'Hatay',
    'Isparta',
    'Mersin',
    'İstanbul',
    'İzmir',
    'Kars',
    'Kastamonu',
    'Kayseri',
    'Kırklareli',
    'Kırşehir',
    'Kocaeli',
    'Konya',
    'Kütahya',
    'Malatya',
    'Manisa',
    'Kahramanmaraş',
    'Mardin',
    'Muğla',
    'Muş',
    'Nevşehir',
    'Niğde',
    'Ordu',
    'Rize',
    'Sakarya',
    'Samsun',
    'Siirt',
    'Sinop',
    'Sivas',
    'Tekirdağ',
    'Tokat',
    'Trabzon',
    'Tunceli',
    'Şanlıurfa',
    'Uşak',
    'Van',
    'Yozgat',
    'Zonguldak',
    'Aksaray',
    'Bayburt',
    'Karaman',
    'Kırıkkale',
    'Batman',
    'Şırnak',
    'Bartın',
    'Ardahan',
    'Iğdır',
    'Yalova',
    'Karabük',
    'Kilis',
    'Osmaniye',
    'Düzce'
];

foreach ($cities as $city) {
    $url = 'https://www.haberturk.com/nobetci-eczaneler/' . strtolower($city);

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    echo $response;

    $eczanetek = explode('<div data-type="type2" class="sticky z-20 top-12 mb-5 p-2.5 bg-white border-t border-b dark:bg-gray-900 dark:border-gray-800">', $response);
    $eczanesay = count($eczanetek) - 1;

    for ($i = 2; $i <= $eczanesay; $i++) {
        $eczaneData = explode('<div data-type="type2" class="sticky z-20 top-12 mb-5 p-2.5 bg-white border-t border-b dark:bg-gray-900 dark:border-gray-800">', $response);

        $eczaneData = explode('<div data-type="type2" class="sticky z-20 top-12 mb-5 p-2.5 bg-white border-t border-b dark:bg-gray-900 dark:border-gray-800">', $eczaneData[$i]);


        $ilce = explode('<div class="text-center font-bold text-xl">', $eczaneData[0]);
        $ilce = explode('</div>', $ilce[1]);

        $name = explode('<p class="block w-full font-bold">', $eczaneData[0]);
        $name = explode('</p>', $name[1]);

        $adres = explode('<p><span class="font-bold">Adres: </span>', $eczaneData[0]);
        $adres = explode('</p>', $adres[1]);

        $telefon = explode('<p><span class="font-bold">Telefon: </span>', $eczaneData[0]);
        $telefon = explode('</p>', $telefon[1]);

        $Pharmacies = new Pharmacies();
        $Pharmacies->city = $city;
        $Pharmacies->date = date('Y-m-d');
        $Pharmacies->name = $name[0];
        $Pharmacies->adres = $adres[0];
        $Pharmacies->district = $ilce[0];
        $Pharmacies->phone = $telefon[0];
        $Pharmacies->save();
    }
}

        return Command::SUCCESS;
    }

}
