<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Newspaper;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class GetNewspaper extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Newspaper';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Gazete Sayfalarını Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {



      $directory = public_path('uploads/newspaper/big');

      // Klasör mevcutsa içindeki tüm dosyaları siler
      if (File::exists($directory)) {
          File::cleanDirectory($directory);
      } else {
      }


      $directory = public_path('uploads/newspaper/min');

      // Klasör mevcutsa içindeki tüm dosyaları siler
      if (File::exists($directory)) {
          File::cleanDirectory($directory);
      } else {
      }

      Newspaper::truncate();

      
      $site="https://www.gazeteoku.com/gazeteler";
      $connect=file_get_contents($site);

      $genelnewspaper=explode('<!-- NEWSPAPER LİST SİDE -->',$connect);
      $genelnewspaper=explode('<!-- /NEWSPAPER LİST SİDE -->',$genelnewspaper[1]);

      $newspaper=explode('<div class="col-12 col-md-6 col-xl-4 col-lg-6">',$genelnewspaper[0]);
      $countnewspaper=count($newspaper)-1;

      for($i=1;$i<=$countnewspaper;$i++){

      $newspapertek=explode('<div class="col-12 col-md-6 col-xl-4 col-lg-6">',$genelnewspaper[0]);
      $newspapertek=explode('<div class="col-12 col-md-6 col-xl-4 col-lg-6">',$newspapertek[$i]);

      $newspaperlink=explode('href="',$newspapertek[0]);
      $newspaperlink=explode('"',$newspaperlink[1]);

      $newspapertitle=explode('<strong>',$newspapertek[0]);
      $newspapertitle=explode('</strong>',$newspapertitle[1]);

      $newspaperdate=explode('<small>',$newspapertek[0]);
      $newspaperdate=explode('</small>',$newspaperdate[1]);

      $newspaperminimage=explode('data-src="',$newspapertek[0]);
      $newspaperminimage=explode('"',$newspaperminimage[1]);

      $newsic=file_get_contents($newspaperlink[0]);

      $newspaperbigimage=explode('<meta property="twitter:image" content="',$newsic);
      $newspaperbigimage=explode('"',$newspaperbigimage[1]);



      $fileName = basename($newspaperbigimage[0]); // URL'den dosya adını alır (ör: aksam-2024-11-11-u2l2.jpg)
      $destinationPath = public_path("uploads/newspaper/big/{$fileName}"); // Hedef dizini oluşturur

      // Dosyayı URL'den indirip doğrudan public/uploads/newspaper dizinine kaydediyoruz
      file_put_contents($destinationPath, file_get_contents($newspaperbigimage[0]));


      $destinationPath = public_path("uploads/newspaper/min/{$fileName}"); // Hedef dizini oluşturur

      // Dosyayı URL'den indirip doğrudan public/uploads/newspaper dizinine kaydediyoruz
      file_put_contents($destinationPath, file_get_contents($newspaperminimage[0]));


      $newNewspaper=new Newspaper();
      $newNewspaper->slug=slug($newspapertitle[0]);
      $newNewspaper->title=($newspapertitle[0]);
      $newNewspaper->date=($newspaperdate[0]);
      $newNewspaper->min_image=($fileName);
      $newNewspaper->large_image=($fileName);
      $newNewspaper->save();

      }

        return Command::SUCCESS;
    }

}
