<?php
// Site adresini sabitle
$siteUrl = 'https://kocaeliduysun.net';

// Log dosyasının yolu
$logFile = __DIR__ . '/cron_log.txt';

// Görevler
$tasks = [
    [
        'path' => '/GetHoroscope',
        'type' => 'interval',
        'interval' => 86400, // 24 saat
        'last_run_file' => __DIR__ . '/last_run_horoscope.txt'
    ],
    [
        'path' => '/bot/getstockexchange',
        'type' => 'interval',
        'interval' => 300, // 5 dakika
        'last_run_file' => __DIR__ . '/last_run_stockexchange.txt'
    ],
    [
        'path' => '/GetSoccerBot',
        'type' => 'interval',
        'interval' => 300, // 5 dakika
        'last_run_file' => __DIR__ . '/last_run_GetSoccerBot.txt'
    ],
    [
        'path' => '/create-sitemap',
        'type' => 'interval',
        'interval' => 21600, // 6 saatte bir
        'last_run_file' => __DIR__ . '/last_run_create-sitemap.txt'
    ],
    [
        'path' => '/ihaajans',
        'type' => 'interval',
        'interval' => 600, // 10 dakika
        'last_run_file' => __DIR__ . '/last_run_ihaajans.txt'
    ],
    [
        'path' => '/GetWeather',
        'type' => 'interval',
        'interval' => 3600, // 1 saat
        'last_run_file' => __DIR__ . '/last_run_weather.txt'
    ],
    [
        'path' => '/GetWeathers',
        'type' => 'interval',
        'interval' => 86400, // 24 saat
        'last_run_file' => __DIR__ . '/last_run_GetWeathers.txt'
    ],
    [
        'path' => '/GetPrayerTimes',
        'type' => 'interval',
        'interval' => 43200, // 12 saat
        'last_run_file' => __DIR__ . '/last_run_GetPrayerTimes.txt'
    ],
    [
        'path' => '/GetPharmacies',
        'type' => 'interval',
        'interval' => 43200, // 12 saat
        'last_run_file' => __DIR__ . '/last_run_GetPharmacies.txt'
    ],
    [
        'path' => '/searchComments',
        'type' => 'interval',
        'interval' => 300, // 5 dakika
        'last_run_file' => __DIR__ . '/last_run_comments.txt'
    ],
    [
        'path' => '/GetNewspaper',
        'type' => 'daily',
        'times' => ['06:00', '07:00', '08:00'],
        'last_run_file' => __DIR__ . '/last_run_newspaper.txt'
    ],
    [
        'path' => '/GetVision',
        'type' => 'daily',
        'times' => ['07:00'],
        'last_run_file' => __DIR__ . '/last_run_vision.txt'
    ],
];

// Şimdiki zaman
$currentTime = time();

foreach ($tasks as $task) {
    // Son çalıştırma zamanını dosyadan oku
    $lastRun = is_file($task['last_run_file']) ? (int)file_get_contents($task['last_run_file']) : 0;

    if ($task['type'] === 'interval') {
        // Aralık kontrolü
        if ($currentTime - $lastRun >= $task['interval']) {
            callUrl($siteUrl . $task['path'], $logFile);
            file_put_contents($task['last_run_file'], $currentTime); // Yeni zamanı yaz
        }
    } elseif ($task['type'] === 'daily') {
        // Günlük zaman kontrolü
        foreach ($task['times'] as $time) {
            $targetTimestamp = strtotime(date('Y-m-d') . ' ' . $time);

            // Hedef zamanı geçtiyse ve daha önce çalıştırılmadıysa
            if ($currentTime >= $targetTimestamp && $lastRun < $targetTimestamp) {
                callUrl($siteUrl . $task['path'], $logFile);
                file_put_contents($task['last_run_file'], $targetTimestamp); // Yeni zamanı yaz
            }
        }
    }
}

/**
 * Belirtilen URL'i çağırır ve log yazar.
 */
function callUrl($url, $logFile)
{
    try {
        $response = file_get_contents($url);
        $logMessage = "[" . date('Y-m-d H:i:s') . "] Called: $url - Success\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        return true;
    } catch (Exception $e) {
        $logMessage = "[" . date('Y-m-d H:i:s') . "] Called: $url - Failed (" . $e->getMessage() . ")\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        return false;
    }
}
