<?php

function callService($url) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);

    return $response;
}

// Servislerin çalıştırılma zamanlarını belirleyin
$lastHoroscopeRun = file_get_contents('last_horoscope_run.txt');
$lastStockExchangeRun = file_get_contents('last_stock_exchange_run.txt');
$lastIhaajansRun = file_get_contents('last_ihaajans_run.txt');
$lastHavaRun = file_get_contents('last_hava_run.txt');
$lastGazeteleraRun = file_get_contents('last_gazeteler_run.txt');
$lastVizyondakilerRun = file_get_contents('last_vizyondakiler_run.txt');
$lastsearchCommentsRun = file_get_contents('search_comments_times_run.txt'); // Yeni eklenen servis


$now = time();
$horoscopeInterval = 86400; // 24 saat
$stockExchangeInterval = 300; // 5 dakika
$ihaajansInterval = 600; // 10 dakika
$HavaInterval = 3600; // 1 saat
$GazetelerInterval = 86400; // 24 saat
$VizyondakilerInterval = 86400; // 24 saat
$searchCommentsInterval = 300; // 5 dakika

// Horoscope servisini çağır
if (!$lastHoroscopeRun || ($now - $lastHoroscopeRun) >= $horoscopeInterval) {
    $horoscope = callService('https://kocaeliduysun.net/GetHoroscope');
    echo "Horoscope Service Response: " . $horoscope . "\n";
    file_put_contents('last_horoscope_run.txt', $now);
}

// Borsa bilgilerini çağır
if (!$lastStockExchangeRun || ($now - $lastStockExchangeRun) >= $stockExchangeInterval) {
    $stockExchange = callService('https://kocaeliduysun.net/bot/getstockexchange');
    echo "Stock Exchange Service Response: " . $stockExchange . "\n";
    file_put_contents('last_stock_exchange_run.txt', $now);
}

// Ihaajans servisini çağır
if (!$lastIhaajansRun || ($now - $lastIhaajansRun) >= $ihaajansInterval) {
    $ihaajans = callService('https://kocaeliduysun.net/ihaajans');
    echo "Ihaajans Service Response: " . $ihaajans . "\n";
    file_put_contents('last_ihaajans_run.txt', $now);
}


// Hava servisini çağır
if (!$lastHavaRun || ($now - $lastHavaRun) >= $HavaInterval) {
    $Hava = callService('https://kocaeliduysun.net/GetWeather');
    echo "Ihaajans Service Response: " . $Hava . "\n";
    file_put_contents('last_hava_run.txt', $now);
}

// Yorum kontrol servisini çağır (5 dk bir)
if (!$lastsearchCommentsRun || ($now - $lastsearchCommentsRun) >= $searchCommentsInterval) {
    $searchComments = callService('https://kocaeliduysun.net/searchComments');
    echo "Hava Service Response: " . $searchComments . "\n";
    file_put_contents('search_comments_times_run.txt', $now);
}

// Gazeteler servisini çağır
if (!$lastGazeteleraRun || ($now - $lastGazeteleraRun) >= $GazetelerInterval) {
    $Gazeteler = callService('https://kocaeliduysun.net/GetNewspaper');
    echo "Gazeteler Service Response: " . $Gazeteler . "\n";
    file_put_contents('last_gazeteler_run.txt', $now);
}

// Vizyondakiler servisini çağır
if (!$lastVizyondakilerRun || ($now - $lastVizyondakilerRun) >= $VizyondakilerInterval) {
    $Vizyondakiler = callService('https://kocaeliduysun.net/GetVision');
    echo "Vizyondakiler Service Response: " . $Vizyondakiler . "\n";
    file_put_contents('last_vizyondakiler_run.txt', $now);
}

echo "servisler kontrol edildi";

?>
