<?php
// Log dosyasının yolu
$logFile = __DIR__ . '/cron_log.txt';

// Görevler
$tasks = [
    [
        'url' => 'https://kocaeliduysun.net/GetHoroscope',
        'type' => 'interval',
        'interval' => 86400, // 24 saat
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/bot/getstockexchange',
        'type' => 'interval',
        'interval' => 300, // 5 dakika
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/ihaajans',
        'type' => 'interval',
        'interval' => 600, // 10 dakika
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/GetWeather',
        'type' => 'interval',
        'interval' => 3600, // 1 saat
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/searchComments',
        'type' => 'interval',
        'interval' => 300, // 5 dakika
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/GetNewspaper',
        'type' => 'daily',
        'times' => ['06:00', '07:00', '08:00'],
        'last_run' => 0
    ],
    [
        'url' => 'https://kocaeliduysun.net/GetVision',
        'type' => 'daily',
        'times' => ['07:00'],
        'last_run' => 0
    ],
];

// Sonsuz döngü
while (true) {
    foreach ($tasks as $index => $task) {
        $currentTime = time(); // Şimdiki zaman (timestamp)

        if ($task['type'] === 'interval') {
            // Aralık kontrolü
            if ($currentTime - $task['last_run'] >= $task['interval']) {
                // URL'i çağır
                if (callUrl($task['url'], $logFile)) {
                    $tasks[$index]['last_run'] = $currentTime;
                }
            }
        } elseif ($task['type'] === 'daily') {
            // Günlük zaman kontrolü
            foreach ($task['times'] as $time) {
                $targetTimestamp = strtotime(date('Y-m-d') . ' ' . $time);

                // Eğer hedef zamanı geçtiyse ve daha önce çalıştırılmadıysa
                if ($currentTime >= $targetTimestamp && $task['last_run'] < $targetTimestamp) {
                    if (callUrl($task['url'], $logFile)) {
                        $tasks[$index]['last_run'] = $targetTimestamp;
                    }
                }
            }
        }
    }

    // CPU'yu yormamak için bekle
    usleep(500000); // 0.5 saniye
}

/**
 * Belirtilen URL'i çağırır ve log yazar.
 */
function callUrl($url, $logFile)
{
    try {
        $response = file_get_contents($url);
        $logMessage = "[" . date('Y-m-d H:i:s') . "] Called: $url - Success\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        return true;
    } catch (Exception $e) {
        $logMessage = "[" . date('Y-m-d H:i:s') . "] Called: $url - Failed (" . $e->getMessage() . ")\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        return false;
    }
}
