<meta charset="utf8">

<?php

ob_start();


ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
set_time_limit(0);


function getPageContent($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

function downloadAndConvertImage($image_url, $save_path) {
    $image_content = file_get_contents($image_url);
    $temp_image_path = tempnam(sys_get_temp_dir(), 'temp_image');
    file_put_contents($temp_image_path, $image_content);
    
    $image_info = getimagesize($temp_image_path);
    $image_type = $image_info[2];
    
    if ($image_type == IMAGETYPE_JPEG || $file_extension == 'jpg') {
    $image = imagecreatefromjpeg($temp_image_path);
    } elseif ($image_type == IMAGETYPE_PNG) {
        $image = imagecreatefrompng($temp_image_path);
    } elseif ($image_type == IMAGETYPE_WEBP) {
        $image = imagecreatefromwebp($temp_image_path);
    } else {
        echo "Desteklenmeyen resim formatı.<br>";
        return false;
    }
    
    if (!file_exists(dirname($save_path))) {
        mkdir(dirname($save_path), 0777, true);
    }
    
    imagewebp($image, $save_path, 80);
    imagedestroy($image);
    unlink($temp_image_path);
    
    return true;
}

function getSeoSlugFromUrl($url) {
    $path = parse_url($url, PHP_URL_PATH);
    $slug = basename($path, '.html');
    return $slug;
}

function fixContentEncoding($content) {
    $content = html_entity_decode($content, ENT_QUOTES, 'UTF-8');
    $content = mb_convert_encoding($content, 'UTF-8', 'auto');
    
    return $content;
}

function saveArticleImages($content, $year, $month, $day, $safe_title) {
    preg_match_all('/<img.*?src="(.*?)".*?>/i', $content, $image_matches);
    
    if (!empty($image_matches[1])) {
        foreach ($image_matches[1] as $image_url) {
            $image_name = basename(parse_url($image_url, PHP_URL_PATH), '.jpg') . '-' . time() . '.webp';
            $image_save_path = "uploads/images/news/$year/$month/$day/$image_name";
            downloadAndConvertImage($image_url, $image_save_path);
            $content = str_replace($image_url, $image_save_path, $content);
        }
    }
    
    return $content;
}

// Veritabanına bağlan
$servername = "localhost";
$username = "kocaeliduysun_habercode";
$password = "Enesbaba33*";
$dbname = "kocaeliduysun_habercode";
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Bağlantı başarısız: " . $conn->connect_error);
}

mysqli_set_charset($conn,"utf8mb4");


function checkCategory($category_name, $conn) {
    // Kategori sorgusunu LIKE ile yapalım
    $sql = "SELECT id FROM categories WHERE name LIKE ?";
    $stmt = $conn->prepare($sql);

    // Joker karakterleri (%) ekleyerek kategoriyi arayalım
    $category_name = '%' . $category_name . '%';

    $stmt->bind_param("s", $category_name);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($category_id);
        $stmt->fetch();
        return $category_id;
    }

    return 28; // Varsayılan kategori ID
}
function insertPhotoGallery($slug, $title, $short_desc, $gallery_image, $publish_date, $publish_time, $category_id, $gallery_images,$gallery_description, $conn) {
    // Aynı slug ile galeri var mı kontrol et
    $sql = "SELECT id FROM photo_galleries WHERE slug = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $stmt->store_result();

    // Eğer aynı slug varsa ekleme yapılmaz
    if ($stmt->num_rows > 0) {
        // echo "Bu galeri zaten mevcut: $slug<br>";
        return;
    }

    // Yayın tarihi ve saat bilgisi
    $created_at = date('Y-m-d H:i:s', strtotime("$publish_date $publish_time"));

    // Fotoğraf galerisi ekleme sorgusu
    $insert_sql = "
    INSERT INTO photo_galleries 
    (category_id, date, time, name, short_description, views_count, status, gallery_image, slug, created_at) 
    VALUES 
    (?, ?, ?, ?, ?, 0, 1, ?, ?, ?)";

    // Galeriyi ekle
    $stmt = $conn->prepare($insert_sql);
    $stmt->bind_param(
    "isssssss", // category_id (int), date (string), time (string), name (string), short_description (string), gallery_image (string), slug (string), created_at (string)
    $category_id, $publish_date, $publish_time, 
    $title, $short_desc, $gallery_image, 
    $slug, $created_at
);

    if ($stmt->execute()) {
        $gallery_id = $stmt->insert_id; // Eklenen galerinin ID'si

        // Eğer galeriden gelen resimler varsa `images` tablosuna kaydedelim
        foreach ($gallery_images as $index => $image_path) {
            $image_description = $gallery_description[$index]; // Dizi elemanını değişkene aktar
            $image_order = $index + 1; // Sırayı bir değişkene aktar

            $image_insert_sql = "
            INSERT INTO photo_gallery_images 
            (gallery_id, short_description, `code`, created_at, image) 
            VALUES 
            (?, ?, ?, ?, ?)";

            $image_stmt = $conn->prepare($image_insert_sql);
            $image_stmt->bind_param(
                "isiss", // news_id (int), order (int), created_at (string), image (string)
                $gallery_id,$image_description, $image_order, $created_at, $image_path
            );
            $image_stmt->execute();
            $image_stmt->close();
        }
    } else {
        echo "Galeri eklenirken hata oluştu: " . $stmt->error . "<br>";
    }

    $stmt->close();
}


                $page=$_GET['page'];

                $curl = curl_init();

                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'https://kocaeliduysun.net/wp-admin/admin-ajax.php',
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                  CURLOPT_POSTFIELDS => array('page' => $page,'count' => '100','action' => 'sunset_load_moreNews','cat' => '8','offset' => '0'),
                  CURLOPT_HTTPHEADER => array(
                    'Cookie: accessed=yes; accessed2=yes'
                  ),
                ));

        $response = curl_exec($curl);

        curl_close($curl);

        $tekhaber=explode('<div data-page="'.($page+1).'">',$response);
        $tekcount=count($tekhaber)-1;
        for($i=50;$i<=$tekcount;$i++){
            $tekhaber=explode('<div data-page="'.($page+1).'">',$response);
            $tekhaber=explode('</div>',$tekhaber[$i]);

            $haberlink=explode('href="',$tekhaber[0]);
            $haberlink=explode('"',$haberlink[1]);

            $haberresim=explode('src="',$tekhaber[0]);
            $haberresim=explode('"',$haberresim[1]);

            $haberisim=explode('alt="',$tekhaber[0]);
            $haberisim=explode('"',$haberisim[1]);

            $haberic=file_get_contents($haberlink[0]);
            $seo_slug = getSeoSlugFromUrl($haberlink[0]);

            $haberresim=explode('<meta property="og:image" content="',$haberic);
            $haberresim=explode('"',$haberresim[1]);


            $kisaaciklama=explode('<meta name="description" content="', $haberic);
            $kisaaciklama=explode('"',$kisaaciklama[1]);

            $date=explode('<meta property="article:published_time" content="',$haberic);
            $date=explode('"',$date[1]);

            $originalDate = $date[0];

            $createdAt = $originalDate;

            $dateTime = new DateTime($originalDate);

            // Tarih (Y-m-d) formatında
            $date = $dateTime->format('d.m.Y');

            // Saat (H:i) formatında, saniyeler hariç
            $time = $dateTime->format('H:i');



            $safe_title = preg_replace('/[^a-zA-Z0-9-_]/', '', str_replace(' ', '-', strtolower($seo_slug)));
            $image_save_path = "uploads/images/news/".$dateTime->format('Y')."/".$dateTime->format('m')."/".$dateTime->format('d')."/$safe_title-" . time() . ".webp";
            
            downloadAndConvertImage($haberresim[0], $image_save_path);

            $galeritek=explode('<div class="gal-number">',$haberic);
            $haberdetaygalericount=count($galeritek)-1;

             $gallery_images = [];
             $gallery_description = [];

            for($a=2;$a<=$haberdetaygalericount;$a++){
                $galeritek=explode('<div class="gal-number">',$haberic);
                $galeritek=explode('</figure>',$galeritek[$a]);


                $galeriresim=explode('<a href="',$galeritek[0]);
                $galeriresim=explode('"',$galeriresim[1]);

                $galeriaciklama=explode('<p>',$galeritek[0]);
                $galeriaciklama=explode('</p>',$galeriaciklama[1]);

                $habericerik_cleaned = saveArticleImages($galeriaciklama[0], $dateTime->format('Y'),$dateTime->format('m'), $dateTime->format('d'), $safe_title);
                $habericerik_cleaned = fixContentEncoding($habericerik_cleaned, 'UTF-8', 'auto');

                $safe_title = preg_replace('/[^a-zA-Z0-9-_]/', '', str_replace(' ', '-', strtolower($seo_slug)));
                $image_save_path_galeri = "uploads/images/news/".$dateTime->format('Y')."/".$dateTime->format('m')."/".$dateTime->format('d')."/$safe_title-" . time() . "-".$a.".webp";
                downloadAndConvertImage($galeriresim[0], $image_save_path_galeri);
                $gallery_images[] = basename($image_save_path_galeri);
                $gallery_description[] = $habericerik_cleaned;




            }


            $short_desc = fixContentEncoding($kisaaciklama[0], 'UTF-8', 'auto');
            $title = fixContentEncoding($haberisim[0], 'UTF-8', 'auto');


             insertPhotoGallery(
                $seo_slug, 
                $title, 
                $short_desc, 
                basename($image_save_path), 
                $date, 
                $time, 
                10, // Varsayılan kategori ID'si
                $gallery_images, 
                $gallery_description, 
                $conn
            );
    }

$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$nextPage = $currentPage + 1;

// Veritabanı bağlantısını kapat
$conn->close();

// Eğer sayfa işlemi tamamlanmışsa, bir sonraki sayfaya geçiş yap
if ($currentPage < 120) { // Örneğin 10 sayfa sınırlı bir döngü ile durdurabilirsiniz
    //header("Location: ?page=$nextPage");
    exit;
} else {
    echo "Tüm sayfalar işlendi.";
}


ob_end_flush();

?>
