
<!-- removeNotificationModal -->
<div id="removeNotificationModal" class="modal fade zoomIn" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="NotificationModalbtn-close"></button>
            </div>
            <div class="modal-body">
                <div class="mt-2 text-center">
                    <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                    <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                        <h4>Are you sure ?</h4>
                        <p class="text-muted mx-4 mb-0">Are you sure you want to remove this Notification ?</p>
                    </div>
                </div>
                <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                    <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn w-sm btn-danger" id="delete-notification">Yes, Delete It!</button>
                </div>
            </div>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


    <div class="modal fade" id="uploadCanvas" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Resim Yükle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                     <input type="file" id="backgroundUpload" accept="image/*" class="form-control mb-3">
                    <div id="cropperContainer" style="display: none;">
        <img id="cropperImage" alt="Kırpılacak Resim">
        <button class="btn btn-success mt-3" id="cropButton">Kırp ve Devam Et</button>
    </div>
        <div id="editorContainer" style="display:none">
            <canvas id="editorCanvas" width="800" height="450"></canvas>
        </div>


        <div id="buttons" class=" mt-3">
            <button class="btn btn-primary" onclick="opentext()">Yazı Düzenlemeleri</button>
            <button class="btn btn-info" onclick="openimage()">Kücük Resim Düzenlemeleri</button>
            <button class="btn btn-warning" onclick="opengradient()">Gradient Düzenlemeleri</button>
            <button class="btn btn-success" onclick="downloadCanvas()">Görseli Kaydet</button>


        </div>

        <div class="controls mt-3 gradient">
             <div class="row">
                <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Başlangıç Renk:</label>
                            <input type="color" id="colorStart" value="#000000" class="form-control">
                     </div>
                   </div>
               <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Bitiş Renk:</label>
            <input type="color" id="colorEnd" value="#ff0000"  class="form-control">
                     </div>
                   </div> 
                   
                   <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Başlangıç Opaklık:</label>
            <input type="range" id="opacityStart" min="0" max="1" step="0.1" value="1"  class="form-range">
                     </div>
                   </div>           
          <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Bitiş Opaklık:</label>
            <input type="range" id="opacityEnd" min="0" max="1" step="0.1" value="0"  class="form-range">
                     </div>
                   </div>  
                    <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Gradient Yönü</label>
           <select id="gradientDirection" class="form-select" >
                <option value="to right">Soldan Sağa</option>
                <option value="to left">Sağdan Sola</option>
                <option value="to top">Aşağıdan Yukarı</option>
                <option value="to bottom">Yukarıdan Aşağı</option>
            </select>
                     </div>
                   </div>  

                    <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Gradient Genişliği (%):</label>
                       <input type="range" id="gradientWidth" min="0" max="100" value="70" class="form-range">

                     </div>
                   </div>  

                    <div class="col-lg-3 col-md-6">
                     <div class="mb-3">
                       <label for="choices-single-default" class="form-label text-muted">Gradient Yüksekliği (%):</label>
                       <input type="range" id="gradientHeight" min="0" max="100" value="50" class="form-range">

                     </div>
                   </div>  
           
            

             <div style="clear:both"></div>
            <button class="btn btn-success" onclick="applyGradient()" style="width:200px; margin-left:15px; margin-right: 15px;">Gradient Uygula / Güncelle</button>
            <button class="btn btn-danger" onclick="removeGradient()"  style="width:200px;" >Gradient Kaldır</button>



        </div>
        </div>
        <div class="controls mt-3 text">
            <div class="row">
   <button class="btn btn-primary " style="    float: right;
    width: 150px;
    margin-bottom: 10px;
    margin-left: 15px;" onclick="addText()">Yeni Yazı Ekle</button>
   <div style="clear:both"></div>
   <div class="col-lg-3 col-md-6">
     <div class="mb-3">
       <label for="choices-single-default" class="form-label text-muted">Yazı Metni</label>
       <input type="text" id="textInput" placeholder="Başlık Metni" class="form-control col-md-3">
     </div>
   </div>
   <div class="col-lg-3 col-md-6">
     <div class="mb-3">
       <label for="choices-single-default" class="form-label text-muted">Yazı Tipi</label>
       <select id="fontSelect" class="form-select">
         <option value="Arial">Arial</option>
         <option value="Verdana">Verdana</option>
         <option value="Times New Roman">Times New Roman</option>
         <option value="Courier New">Courier New</option>
         <option value="Roboto, Helvetica">Roboto, Helvetica</option>
       </select>
     </div>
   </div>
   <div class="col-lg-3 col-md-6">
     <div class="mb-3">
       <label for="choices-single-default" class="form-label text-muted">Yazı Fontu</label>
       <input type="number" id="fontSizeInput" placeholder="Boyut" value="20" class="form-control col-md-3">
     </div>
   </div>
   <div class="col-lg-3 col-md-6">
     <div class="mb-3">
       <label for="choices-single-default" class="form-label text-muted">Yazı Rengi</label>
       <input type="color" id="colorPicker" class="form-control  col-md-3">
     </div>
   </div>
   <div class="col-lg-3 col-md-6">
     <div class="mb-3">
       <label for="choices-single-default" class="form-label text-muted">Yazı Kalınlığı</label>
       <input type="number" id="fontWeightInput" placeholder="Kalınlık" value="400" class="form-control  col-md-3">
     </div>
   </div>
   <div class="col-lg-3 col-md-6" style="align-items: center;display: flex;">
     <div class="mb-3">
       <div class="form-check form-switch form-switch-lg" dir="ltr">
         <input type="checkbox" class="form-check-input" id="shadowToggle" checked="">
         <label class="form-check-label" for="shadowToggle">Yazı Gölge Durumu</label>
       </div>
     </div>
   </div>
   <div style="clear:both"></div>
   <button class="btn btn-success col-md-3" onclick="updateText()" style="margin-left:15px; margin-right: 15px;">Seçili Yazıyı Güncelle</button>
   <button class="btn btn-danger  col-md-3" onclick="deleteText()">Seçili Yazıyı Sil</button>
 </div>
        </div>

        <div class="controls mt-5 image">
<input type="file" id="smallImageUpload" accept="image/*" class="form-control mb-3">

                        <button class="btn btn-danger" onclick="deleteSmallImage()">Küçük Resmi Sil</button>


        </div>


                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="updateCanvasLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="updateCanvasLabel">Resim Yükle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="uploadForm" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="upload" class="form-label">Resim Seç</label>
                            <input class="form-control" type="file" name="file" id="upload" >
                        </div>
                        <button type="submit" class="btn btn-primary">Yükle</button>
                    </form>
                    <div id="uploadResult" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>

   <button onclick="topFunction()" class="btn btn-primary btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>



    <!-- Theme Settings -->
   
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.js"></script>

    <!-- JAVASCRIPT -->
    <script src="/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="/assets/libs/node-waves/waves.min.js"></script>
    <script src="/assets/libs/feather-icons/feather.min.js"></script>
    <script src="/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="/assets/libs/choices.min.js"></script>

    <!-- apexcharts -->
    <script src="/assets/libs/apexcharts/apexcharts.min.js"></script>

    <!-- Vector map-->
    <script src="/assets/libs/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="/assets/libs/jsvectormap/maps/world-merc.js"></script>

    <!--Swiper slider js-->
    <script src="/assets/libs/swiper/swiper-bundle.min.js"></script>

    <!-- Dashboard init -->
    <script src="/assets/js/pages/dashboard-ecommerce.init.js"></script>
    <script src="/assets/js/Notify.js"></script>

    <!-- App js -->
    <script src="/assets/js/app.js"></script>
    <script src="/assets/js/pnotify.min.js  "></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

<style type="text/css">
    
 canvas {
            border: 1px solid #ccc;
            display: block;
            margin: 20px auto;
        }
        .controls {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
            margin: 20px auto;
            display: none;
        }
        #editorContainer {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        #buttons{    text-align: center; display: none}

</style>

    <?php
    $messages = App\Utilities\FlashNotification::get();
    ?>

    <?php if(isset($messages)): ?>
        <script>     
        $(function() {
            new PNotify({
                title: '<?php echo e($messages['title']); ?>',
                text: '<?php echo e($messages['message']); ?>',
                <?php if($messages['type']=='success'): ?>
                addclass: "stack-bottom-right bg-success",
                <?php elseif($messages['type']=='error'): ?>
                addclass: "stack-bottom-right bg-danger",
                <?php elseif($messages['type']=='warning'): ?>
                addclass: "stack-bottom-right bg-warning",
                <?php elseif($messages['type']=='info'): ?>
                addclass: "stack-bottom-right bg-info",
                <?php endif; ?>
            });

            Toastify({
            text: "<?php echo e($messages['message']); ?>",
            duration: 14000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                <?php if($messages['type']=='success'): ?>
                background: "#66c99b",
                <?php elseif($messages['type']=='error'): ?>
                background: "#00b09b",
                <?php elseif($messages['type']=='warning'): ?>
                background: "#ffd57c",
                <?php elseif($messages['type']=='info'): ?>
                background: "#f18275",
                <?php endif; ?>
                
            },
            onClick: function(){} // Callback after click
            }).showToast();
                    })


    </script>

    <?php endif; ?>



    <script type="text/javascript">
         $(document).ready(function() {
     $('#uploadForm').on('submit', function(e) {
                    e.preventDefault();
                    var formData = new FormData(this);
                    $.ajax({
                        url: "<?php echo e(env('PANEL_URL')); ?>upload-image",
                        method: "POST",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(response) {
                            if (response.uploaded) {
                                $('#uploadResult').html('<div class="alert alert-success">Yükleme başarılı: <a style="word-wrap: break-word;" href="<?php echo e(env('SITE_URL')); ?>' + response.location + '" target="_blank"><?php echo e(env('SITE_URL')); ?>' + response.location + '</a></div>');
                            } else {
                                $('#uploadResult').html('<div class="alert alert-danger">' + response.error.message + '</div>');
                            }
                        },
                        error: function(response) {
                            $('#uploadResult').html('<div class="alert alert-danger">Yükleme sırasında bir hata oluştu.</div>');
                        }
                    });
                });
            });
    </script>

    <?php echo $__env->yieldContent('script'); ?>



<script type="text/javascript">
    const canvas = document.getElementById("editorCanvas");
    const ctx = canvas.getContext("2d");
    const backgroundUpload = document.getElementById("backgroundUpload");
    const smallImageUpload = document.getElementById("smallImageUpload");
const cropperContainer = document.getElementById("cropperContainer");
const cropperImage = document.getElementById("cropperImage");
const cropButton = document.getElementById("cropButton");
const buttons = document.getElementById("buttons");
const editorContainer = document.getElementById("editorContainer");

    let backgroundImage = null;
    let smallImages = [];
    let texts = [];
    let gradientConfig = null;
    let selectedTextIndex = null;
    let selectedSmallImageIndex = null;
    let isDragging = false;
    let resizing = false;
    let NewCropper = null;

    // Arka Plan Resmi Yükleme
    backgroundUpload.addEventListener("change", (e) => {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (event) {
            cropperImage.src = event.target.result;
            cropperContainer.style.display = "block";
            editorContainer.style.display = "none";

            // Cropper.js başlat
            if (NewCropper) NewCropper.destroy(); // Mevcut cropper'ı temizle
            NewCropper = new Cropper(cropperImage, {
                aspectRatio: 16 / 9, // 800x450 oranı
                viewMode: 1,
                autoCropArea: 1,
                responsive: true,
            });
        };
        reader.readAsDataURL(file);
    }
});

// Kırp ve Canvas'a Aktar
cropButton.addEventListener("click", () => {
    const croppedCanvas = NewCropper.getCroppedCanvas({
        width: 800,
        height: 450,
    });

    // Kırpılmış resmi `backgroundImage` olarak sakla
    backgroundImage = new Image();
    backgroundImage.src = croppedCanvas.toDataURL();

    // Resmi hemen canvas'a çiz
    backgroundImage.onload = function () {
        ctx.clearRect(0, 0, canvas.width, canvas.height); // Canvas'ı temizle
        ctx.drawImage(backgroundImage, 0, 0, canvas.width, canvas.height); // Resmi çiz
        cropperContainer.style.display = "none"; // Cropper alanını gizle
        editorContainer.style.display = "block"; // Düzenleme alanını göster
        buttons.style.display = "block"; // Düzenleme alanını göster
        backgroundUpload.style.display="none";
        renderCanvas(); // Tüm bileşenleri yeniden çiz
    };
});

    // Küçük Resim Yükleme
    smallImageUpload.addEventListener("change", (e) => {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function (event) {
                const img = new Image();
                img.src = event.target.result;
                img.onload = function () {
                    smallImages.push({
                        image: img,
                        x: canvas.width / 4,
                        y: canvas.height / 4,
                        width: img.width / 4,
                        height: img.height / 4,
                    });
                    renderCanvas();
                };
            };
            reader.readAsDataURL(file);
        }
    });

    // Gradient Uygulama
    function applyGradient() {
        const colorStart = document.getElementById("colorStart").value;
        const colorEnd = document.getElementById("colorEnd").value;
        const opacityStart = parseFloat(document.getElementById("opacityStart").value);
        const opacityEnd = parseFloat(document.getElementById("opacityEnd").value);
        const direction = document.getElementById("gradientDirection").value;
        const gradientWidthPercent = parseInt(document.getElementById("gradientWidth").value, 10) / 100;
        const gradientHeightPercent = parseInt(document.getElementById("gradientHeight").value, 10) / 100;

        gradientConfig = { colorStart, colorEnd, opacityStart, opacityEnd, direction, gradientWidthPercent, gradientHeightPercent };
        renderCanvas();
    }

    // Gradient Kaldırma
    function removeGradient() {
        gradientConfig = null;
        renderCanvas();
    }

    // Gradient Çizimi
    function drawGradient() {
        if (!gradientConfig) return;

        const { colorStart, colorEnd, opacityStart, opacityEnd, direction, gradientWidthPercent, gradientHeightPercent } = gradientConfig;
        let gradient;

        const gradientWidth = canvas.width * gradientWidthPercent;
        const gradientHeight = canvas.height * gradientHeightPercent;

        if (direction === "to right") {
            gradient = ctx.createLinearGradient(0, 0, gradientWidth, 0);
            gradient.addColorStop(0, `${colorStart}${convertOpacity(opacityStart)}`);
            gradient.addColorStop(1, `${colorEnd}${convertOpacity(opacityEnd)}`);
            ctx.fillStyle = gradient;
            ctx.fillRect(0, 0, gradientWidth, canvas.height);
        } else if (direction === "to left") {
            gradient = ctx.createLinearGradient(canvas.width, 0, canvas.width - gradientWidth, 0);
            gradient.addColorStop(0, `${colorStart}${convertOpacity(opacityStart)}`);
            gradient.addColorStop(1, `${colorEnd}${convertOpacity(opacityEnd)}`);
            ctx.fillStyle = gradient;
            ctx.fillRect(canvas.width - gradientWidth, 0, gradientWidth, canvas.height);
        } else if (direction === "to top") {
            gradient = ctx.createLinearGradient(0, canvas.height, 0, canvas.height - gradientHeight);
            gradient.addColorStop(0, `${colorStart}${convertOpacity(opacityStart)}`);
            gradient.addColorStop(1, `${colorEnd}${convertOpacity(opacityEnd)}`);
            ctx.fillStyle = gradient;
            ctx.fillRect(0, canvas.height - gradientHeight, canvas.width, gradientHeight);
        } else if (direction === "to bottom") {
            gradient = ctx.createLinearGradient(0, 0, 0, gradientHeight);
            gradient.addColorStop(0, `${colorStart}${convertOpacity(opacityStart)}`);
            gradient.addColorStop(1, `${colorEnd}${convertOpacity(opacityEnd)}`);
            ctx.fillStyle = gradient;
            ctx.fillRect(0, 0, canvas.width, gradientHeight);
        }
    }

    // Opaklık Dönüştürme
    function convertOpacity(opacity) {
        return Math.round(opacity * 255).toString(16).padStart(2, "0");
    }

    // Yazı Ekleme
    function addText() {
        const text = `Yazı ${texts.length + 1}`;
        texts.push({
            text,
            x: canvas.width / 2,
            y: canvas.height / 2,
            width: 200,
            color: "black",
            size: 30,
            font: "Roboto, Helvetica",
            fontWeight: 900,
            shadow: true,
        });
        renderCanvas();
    }

    // Yazı Güncelleme
    function updateText() {
        if (selectedTextIndex !== null && texts[selectedTextIndex]) {
            const textInput = document.getElementById("textInput").value;
            const fontSelect = document.getElementById("fontSelect").value;
            const fontSize = parseInt(document.getElementById("fontSizeInput").value, 10);
            const color = document.getElementById("colorPicker").value;
            const fontWeight = parseInt(document.getElementById("fontWeightInput").value, 10);
            const shadow = document.getElementById("shadowToggle").checked;

            texts[selectedTextIndex] = {
                ...texts[selectedTextIndex],
                text: textInput,
                font: fontSelect,
                size: fontSize,
                color: color,
                fontWeight: fontWeight,
                shadow: shadow,
            };
            renderCanvas();
        }
    }

    // Seçim İşlemleri
    canvas.addEventListener("mousedown", (e) => {
        const { offsetX, offsetY } = e;

        selectedSmallImageIndex = smallImages.findIndex(
            (img) =>
                offsetX > img.x &&
                offsetX < img.x + img.width &&
                offsetY > img.y &&
                offsetY < img.y + img.height
        );

        if (selectedSmallImageIndex !== -1) {
            const img = smallImages[selectedSmallImageIndex];
            const resizeHandleSize = 10;

            if (
                offsetX > img.x + img.width - resizeHandleSize &&
                offsetY > img.y + img.height - resizeHandleSize
            ) {
                resizing = true;
            } else {
                isDragging = true;
            }
        } else {
            selectedTextIndex = texts.findIndex(
                (text) =>
                    offsetX > text.x &&
                    offsetX < text.x + text.width &&
                    offsetY > text.y - text.size &&
                    offsetY < text.y
            );

            if (selectedTextIndex !== -1) {
                const text = texts[selectedTextIndex];
                const resizeHandleSize = 10;

                if (
                    offsetX > text.x + text.width - resizeHandleSize &&
                    offsetY > text.y - text.size - resizeHandleSize &&
                    offsetY < text.y
                ) {
                    resizing = true;
                } else {
                    isDragging = true;
                }
                updateTextControls();
            } else {
                selectedTextIndex = null; // Yazı veya resim seçilmediğinde, seçimi kaldır.
                selectedSmallImageIndex = null;
            }
        }

        renderCanvas(); // Seçim durumunu güncelle
    });

    // Sürükleme ve Yeniden Boyutlandırma
    canvas.addEventListener("mousemove", (e) => {
        if (isDragging || resizing) {
            const { offsetX, offsetY } = e;

            if (resizing && selectedSmallImageIndex !== null && smallImages[selectedSmallImageIndex]) {
                canvas.style.cursor = "nwse-resize";
                const img = smallImages[selectedSmallImageIndex];
                img.width = Math.max(offsetX - img.x, 20);
                img.height = Math.max(offsetY - img.y, 20);
                renderCanvas();
            } else if (resizing && selectedTextIndex !== null && texts[selectedTextIndex]) {
                canvas.style.cursor = "nesw-resize";
                const text = texts[selectedTextIndex];
                text.width = Math.max(offsetX - text.x, 20);
                renderCanvas();
            } else if (isDragging && selectedSmallImageIndex !== null && smallImages[selectedSmallImageIndex]) {
                canvas.style.cursor = "move";
                const img = smallImages[selectedSmallImageIndex];
                img.x = offsetX - img.width / 2;
                img.y = offsetY - img.height / 2;
                renderCanvas();
            } else if (isDragging && selectedTextIndex !== null && texts[selectedTextIndex]) {
                canvas.style.cursor = "move";
                const text = texts[selectedTextIndex];
                text.x = offsetX;
                text.y = offsetY;
                renderCanvas();
            } else {
                canvas.style.cursor = "default";
            }
        }
    });

    canvas.addEventListener("mouseup", () => {
        isDragging = false;
        resizing = false;
        canvas.style.cursor = "default";
    });

    // Text Kontrollerini Güncelleme
    function updateTextControls() {
        if (selectedTextIndex !== null && texts[selectedTextIndex]) {
            const selectedText = texts[selectedTextIndex];
            document.getElementById("textInput").value = selectedText.text;
            document.getElementById("fontSelect").value = selectedText.font;
            document.getElementById("fontSizeInput").value = selectedText.size;
            document.getElementById("colorPicker").value = selectedText.color;
            document.getElementById("fontWeightInput").value = selectedText.fontWeight;
            document.getElementById("shadowToggle").checked = selectedText.shadow;
        }
    }

    // Canvas'ı Yeniden Çizme
    function renderCanvas() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        if (backgroundImage) ctx.drawImage(backgroundImage, 0, 0, canvas.width, canvas.height);
        drawGradient();

        smallImages.forEach((img, index) => {
            ctx.drawImage(img.image, img.x, img.y, img.width, img.height);
            // Seçili küçük resme kenarlık ekle
            if (index === selectedSmallImageIndex) {
                ctx.setLineDash([5, 3]);
                ctx.strokeStyle = "blue";
                ctx.strokeRect(img.x, img.y, img.width, img.height);
                ctx.setLineDash([]);
            }
        });

        texts.forEach((text, index) => {
            ctx.font = `${text.fontWeight} ${text.size}px ${text.font}`;
            ctx.fillStyle = text.color;
            ctx.textAlign = "left";

            if (text.shadow) {
                ctx.shadowColor = "rgba(0, 0, 0, 0.5)";
                ctx.shadowBlur = 4;
                ctx.shadowOffsetX = 2;
                ctx.shadowOffsetY = 2;
            } else {
                ctx.shadowColor = "transparent";
                ctx.shadowBlur = 0;
                ctx.shadowOffsetX = 0;
                ctx.shadowOffsetY = 0;
            }

            const words = text.text.split(" ");
            let line = "";
            const lineHeight = text.size * 1.2;
            let y = text.y;
            const maxWidth = text.width;

            words.forEach((word) => {
                const testLine = line + word + " ";
                const testWidth = ctx.measureText(testLine).width;
                if (testWidth > maxWidth && line !== "") {
                    ctx.fillText(line, text.x, y);
                    line = word + " ";
                    y += lineHeight;
                } else {
                    line = testLine;
                }
            });
            ctx.fillText(line, text.x, y);

            // Seçili yazıya kenarlık ekle
            if (index === selectedTextIndex) {
                ctx.setLineDash([5, 3]);
                ctx.strokeStyle = "blue";
                ctx.strokeRect(text.x, text.y - text.size, text.width, lineHeight * (y - text.y + lineHeight) / lineHeight);
                ctx.setLineDash([]);
            }
        });
    }

    // Küçük Resmi Silme
    function deleteSmallImage() {
        if (selectedSmallImageIndex !== null) {
            smallImages.splice(selectedSmallImageIndex, 1);
            selectedSmallImageIndex = null;
            renderCanvas();
        }
    }

    // Yazıyı Silme
    function deleteText() {
        if (selectedTextIndex !== null) {
            texts.splice(selectedTextIndex, 1);
            selectedTextIndex = null;
            renderCanvas();
        }
    }

    // Canvas'ı Kaydetme
    function downloadCanvas() {
        // Kenarlıkları kaldırarak çizim yap
        selectedTextIndex = null;
        selectedSmallImageIndex = null;
        renderCanvas();

        const link = document.createElement("a");
        link.download = "canvas-image.png";
        link.href = canvas.toDataURL();
        link.click();
    }


    function opentext(){
        $(".gradient").hide();
        $(".image").hide();
        $(".text").toggle();
    }

     function opengradient(){
        $(".text").hide();
        $(".image").hide();
        $(".gradient").toggle();
    }

     function openimage(){
        $(".text").hide();
        $(".gradient").hide();
        $(".image").toggle();
    }


</script>
</body>


<!-- Mirrored from themesbrand.com/velzon/html/galaxy/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 01 Apr 2024 22:13:05 GMT -->
</html><?php /**PATH /home/kocaeliduysun/public_html/panel/resources/views/layouts/footer.blade.php ENDPATH**/ ?>