<?php $__env->startSection('title', 'Öğeler'); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                        <h4 class="mb-sm-0">Öğeleri Görüntüle</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Ayarlar</a></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <!-- Sol tarafta kategoriler -->
                <div class="col-lg-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Kategoriler</h5>
                        </div>
                        <div class="card-body" id="categoryList">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="draggable btn btn-outline-primary btn-border col-md-12 mt-2" draggable="true" data-item="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Sol tarafta diğer öğeler -->
                <div class="col-lg-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Diğer Öğeler</h5>
                        </div>
                        <div class="card-body" id="otherItemsList">
                            <?php $__currentLoopData = $otherItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="draggable btn btn-outline-primary btn-border col-md-12 mt-2" draggable="true" data-item="<?php echo e($item); ?>"><?php echo e($item); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Sağ tarafta sürükle bırak yapılacak alan -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Anasayfa Tasarımı</h5>
                        </div>
                        <div class="card-body drop-zone" id="dropZone" style="min-height: 400px;">
                            <!-- Kaydedilen öğeleri burada sırayla göster -->
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(is_array($item) && isset($item['item']) && isset($item['origin'])): ?>
                                    <div class="draggable btn btn-outline-primary btn-border col-md-12 mt-2 position-relative" draggable="true" data-item="<?php echo e($item['item']); ?>" data-origin="<?php echo e($item['origin']); ?>">
                                        <?php echo e($item['item']); ?>

                                        <div class="position-absolute top-0 end-0 d-flex">
                                            <button class="btn btn-danger btn-sm remove-button" onclick="removeItem(this.parentNode.parentNode)" style="padding: 0px 10px;
    font-size:23px;">&times;</button>
                                            <button class="btn btn-light btn-sm ms-1 move-up-button" onclick="moveItemUp(this.parentNode.parentNode)" style="padding: 0px 10px;
    font-size:23px;">&#8593;</button>
                                            <button class="btn btn-light btn-sm ms-1 move-down-button" onclick="moveItemDown(this.parentNode.parentNode)" style="padding: 0px 10px;
    font-size:23px;">&#8595;</button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    const dropZone = document.getElementById('dropZone');
    const categoryList = document.getElementById('categoryList');
    const otherItemsList = document.getElementById('otherItemsList');

    // Tüm sürüklenebilir öğeleri seçin
    document.querySelectorAll('.draggable').forEach(draggable => {
        draggable.addEventListener('dragstart', dragStart);
        draggable.addEventListener('dragend', dragEnd);
    });

    function dragStart(e) {
        e.dataTransfer.setData('text', e.target.dataset.item);
        e.dataTransfer.setData('origin', e.target.closest('.card-body').id);
        setTimeout(() => {
            e.target.classList.add('hide');
        }, 0);
    }

    function dragEnd(e) {
        e.target.classList.remove('hide');
    }

    // Drop zone'a sürüklenebilir olayları ekleyin
    dropZone.addEventListener('dragover', (e) => {
        e.preventDefault();
    });

    dropZone.addEventListener('drop', (e) => {
        e.preventDefault();
        const itemText = e.dataTransfer.getData('text');
        const origin = e.dataTransfer.getData('origin');
        addItemToDropZone(itemText, origin);
        saveLayout();
    });

    function addItemToDropZone(itemText, origin) {
        // Yeni bir öğe oluştur ve içeriğini belirle
        const newItem = document.createElement('div');
        newItem.classList.add('draggable', 'btn', 'btn-outline-primary', 'btn-border', 'col-md-12', 'mt-2', 'position-relative');
        newItem.textContent = itemText;
        newItem.draggable = true;
        newItem.dataset.item = itemText;
        newItem.dataset.origin = origin;

        // Silme ve taşıma butonları ekle
        const controls = document.createElement('div');
        controls.classList.add('position-absolute', 'top-0', 'end-0', 'd-flex');

        const removeButton = document.createElement('button');
        removeButton.innerHTML = "&times;";
        removeButton.classList.add('btn', 'btn-danger', 'btn-sm', 'remove-button');
        removeButton.style.padding = "0 10px";
        removeButton.style.fontSize = "23px";
        removeButton.onclick = function () {
            removeItem(newItem);
        };

        const moveUpButton = document.createElement('button');
        moveUpButton.innerHTML = "&#8593;";
        moveUpButton.classList.add('btn', 'btn-light', 'btn-sm', 'ms-1', 'move-up-button');
        moveUpButton.style.padding = "0 10px";
        moveUpButton.style.fontSize = "23px";
        moveUpButton.onclick = function () {
            moveItemUp(newItem);
        };

        const moveDownButton = document.createElement('button');
        moveDownButton.innerHTML = "&#8595;";
        moveDownButton.classList.add('btn', 'btn-light', 'btn-sm', 'ms-1', 'move-down-button');
        moveDownButton.style.padding = "0 10px";
        moveDownButton.style.fontSize = "23px";
        moveDownButton.onclick = function () {
            moveItemDown(newItem);
        };

        controls.appendChild(removeButton);
        controls.appendChild(moveUpButton);
        controls.appendChild(moveDownButton);
        newItem.appendChild(controls); // Öğeye kontrol butonlarını ekle

        dropZone.appendChild(newItem); // Öğeyi dropZone'a ekle

        // Yeni öğe için sürüklenebilir olayları tanımla
        newItem.addEventListener('dragstart', dragStart);
        newItem.addEventListener('dragend', dragEnd);

        // Sol taraftaki aynı öğeyi gizle
        const leftItem = document.querySelector(`[data-item="${itemText}"]`);
        if (leftItem) leftItem.remove();
    }

    function removeItem(itemElement) {
        const itemText = itemElement.dataset.item;
        const origin = itemElement.dataset.origin;

        // Öğeyi sağ taraftan kaldır
        itemElement.remove();

        // Öğeyi geldiği yere geri ekle
        if (origin === 'categoryList') {
            addItemToCategoryList(itemText);
        } else if (origin === 'otherItemsList') {
            addItemToOtherItemsList(itemText);
        }

        // Değişiklikleri kaydet
        saveLayout();
    }

    function addItemToCategoryList(itemText) {
        // Kategori listesine öğeyi geri ekleme
        const newItem = document.createElement('div');
        newItem.classList.add('draggable', 'btn', 'btn-outline-primary', 'btn-border', 'col-md-12', 'mt-2');
        newItem.textContent = itemText;
        newItem.draggable = true;
        newItem.dataset.item = itemText;

        categoryList.appendChild(newItem);

        // Yeni öğe için sürüklenebilir olayları tanımla
        newItem.addEventListener('dragstart', dragStart);
        newItem.addEventListener('dragend', dragEnd);
    }

    function addItemToOtherItemsList(itemText) {
        // Diğer öğeler listesine öğeyi geri ekleme
        const newItem = document.createElement('div');
        newItem.classList.add('draggable', 'btn', 'btn-outline-primary', 'btn-border', 'col-md-12', 'mt-2');
        newItem.textContent = itemText;
        newItem.draggable = true;
        newItem.dataset.item = itemText;

        otherItemsList.appendChild(newItem);

        // Yeni öğe için sürüklenebilir olayları tanımla
        newItem.addEventListener('dragstart', dragStart);
        newItem.addEventListener('dragend', dragEnd);
    }

    function moveItemUp(itemElement) {
        const previousElement = itemElement.previousElementSibling;
        if (previousElement) {
            dropZone.insertBefore(itemElement, previousElement);
            saveLayout();
        }
    }

    function moveItemDown(itemElement) {
        const nextElement = itemElement.nextElementSibling;
        if (nextElement) {
            dropZone.insertBefore(nextElement, itemElement);
            saveLayout();
        }
    }

    function saveLayout() {
        // Sağ tarafta yer alan öğeleri layout olarak kaydet
        const items = Array.from(dropZone.querySelectorAll('.draggable')).map(item => {
            return {
                item: item.dataset.item,
                origin: item.dataset.origin
            };
        });

        // AJAX ile layout'u sunucuya gönder
        fetch('/save-layout', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ layout: items })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                console.log("Layout başarıyla kaydedildi");
            } else {
                console.error("Layout kaydedilemedi");
            }
        })
        .catch(error => console.error("Bir hata oluştu:", error));
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kocaeliduysun/public_html/panel/resources/views/settings/element.blade.php ENDPATH**/ ?>