<?php



use Illuminate\Support\Facades\Route;







Route::post('login/submit',[App\Http\Controllers\UserController::class , 'loginSubmit'])->name('user.login.submit');

Route::get('bot/getstockexchange',[App\Http\Controllers\BotController::class , 'getstockexchange'])->name('bot.getstockexchange');


Route::get('ihaajans', function () {

    \Artisan::call('command:ihaajans');

});


Route::get('GetHoroscope', function () {

    \Artisan::call('command:Horoscope');

});


Auth::routes();



Route::middleware('auth')->group(function () {




Route::get('/', [App\Http\Controllers\HomeController::class, 'welcome'])->name('welcome');




Route::post('/check-seo-url', [App\Http\Controllers\NewsController::class, 'checkSeoUrl'])->name('check.seo.url');

Route::get('/category/list', [App\Http\Controllers\CategoryController::class, 'Index'])->name('category.index');

Route::get('/category/create', [App\Http\Controllers\CategoryController::class, 'Create'])->name('category.create');

Route::get('/category/{categoryID}/edit', [App\Http\Controllers\CategoryController::class, 'Edit'])->name('category.edit');

Route::post('/category/{categoryID}/edit/update', [App\Http\Controllers\CategoryController::class, 'Update'])->name('category.update');

Route::post('/category/create/save', [App\Http\Controllers\CategoryController::class, 'Save'])->name('category.save');

Route::get('/category/{categoryID}/deleted', [App\Http\Controllers\CategoryController::class, 'Delete'])->name('category.delete');




Route::get('/authors/list', [App\Http\Controllers\AuthorController::class, 'Index'])->name('author.index');

Route::get('/authors/create', [App\Http\Controllers\AuthorController::class, 'Create'])->name('author.create');

Route::get('/authors/{authorID}/edit', [App\Http\Controllers\AuthorController::class, 'Edit'])->name('author.edit');

Route::post('/authors/{authorID}/edit/update', [App\Http\Controllers\AuthorController::class, 'Update'])->name('author.update');

Route::post('/authors/create/save', [App\Http\Controllers\AuthorController::class, 'Save'])->name('author.save');

Route::get('/authors/{authorID}/deleted', [App\Http\Controllers\AuthorController::class, 'Delete'])->name('author.delete');


Route::get('/editors/list', [App\Http\Controllers\EditorController::class, 'Index'])->name('editor.index');

Route::get('/editors/create', [App\Http\Controllers\EditorController::class, 'Create'])->name('editor.create');

Route::get('/editors/{editorID}/edit', [App\Http\Controllers\EditorController::class, 'Edit'])->name('editor.edit');

Route::post('/editors/{editorID}/edit/update', [App\Http\Controllers\EditorController::class, 'Update'])->name('editor.update');

Route::post('/editors/create/save', [App\Http\Controllers\EditorController::class, 'Save'])->name('editor.save');

Route::get('/editors/{editorID}/deleted', [App\Http\Controllers\EditorController::class, 'Delete'])->name('editor.delete');



Route::get('/comments/list', [App\Http\Controllers\NewsController::class, 'getComments'])->name('comments.index');

Route::get('/comments/{commentID}/edit/update', [App\Http\Controllers\NewsController::class, 'commentUpdate'])->name('comment.update');

Route::get('/comments/{commentID}/deleted', [App\Http\Controllers\NewsController::class, 'commentDelete'])->name('comment.delete');


Route::get('/pages/list', [App\Http\Controllers\PageController::class, 'Index'])->name('pages.index');

Route::get('/pages/create', [App\Http\Controllers\PageController::class, 'Create'])->name('pages.create');

Route::get('/pages/{pageID}/edit', [App\Http\Controllers\PageController::class, 'Edit'])->name('pages.edit');

Route::post('/pages/{pageID}/edit/update', [App\Http\Controllers\PageController::class, 'Update'])->name('pages.update');

Route::post('/pages/create/save', [App\Http\Controllers\PageController::class, 'Save'])->name('pages.save');

Route::get('/pages/{pageID}/deleted', [App\Http\Controllers\PageController::class, 'Delete'])->name('pages.delete');



Route::get('/menus/list', [App\Http\Controllers\MenuController::class, 'Index'])->name('menus.index');

Route::get('/menus/create', [App\Http\Controllers\MenuController::class, 'Create'])->name('menus.create');

Route::get('/menus/{menuID}/edit', [App\Http\Controllers\MenuController::class, 'Edit'])->name('menus.edit');

Route::post('/menus/{menuID}/edit/update', [App\Http\Controllers\MenuController::class, 'Update'])->name('menus.update');

Route::post('/menus/create/save', [App\Http\Controllers\MenuController::class, 'Save'])->name('menus.save');

Route::get('/menus/{menuID}/deleted', [App\Http\Controllers\MenuController::class, 'Delete'])->name('menus.delete');




Route::get('/ads/list', [App\Http\Controllers\AdsController::class, 'Index'])->name('ads.index');

Route::get('/ads/create', [App\Http\Controllers\AdsController::class, 'Create'])->name('ads.create');

Route::get('/ads/{adsID}/edit', [App\Http\Controllers\AdsController::class, 'Edit'])->name('ads.edit');

Route::post('/ads/{adsID}/edit/update', [App\Http\Controllers\AdsController::class, 'Update'])->name('ads.update');

Route::post('/ads/create/save', [App\Http\Controllers\AdsController::class, 'Save'])->name('ads.save');

Route::get('/ads/{adsID}/deleted', [App\Http\Controllers\AdsController::class, 'Delete'])->name('ads.delete');



Route::get('/elemets', [App\Http\Controllers\SettingController::class, 'Elements'])->name('settings.elements');

Route::get('/code', [App\Http\Controllers\SettingController::class, 'Code'])->name('settings.code');

Route::post('/save-layout', [App\Http\Controllers\LayoutController::class, 'saveLayout'])->name('save.layout');


Route::get('/settings', [App\Http\Controllers\SettingController::class, 'Index'])->name('settings.index');

Route::post('/settings/update', [App\Http\Controllers\SettingController::class, 'Update'])->name('settings.update');

Route::get('/bot-agency/iha', [App\Http\Controllers\AgencyBotController::class, 'ihaindex'])->name('botagency.iha.index');

Route::post('/bot-agency/ihaupdate', [App\Http\Controllers\AgencyBotController::class, 'ihaupdate'])->name('botagency.iha.update');


Route::get('/bot-agency/aa', [App\Http\Controllers\AgencyBotController::class, 'aaindex'])->name('botagency.aa.index');

Route::post('/bot-agency/aaupdate', [App\Http\Controllers\AgencyBotController::class, 'aaupdate'])->name('botagency.aa.update');


Route::get('/news/list', [App\Http\Controllers\NewsController::class, 'Index'])->name('news.index');

Route::get('/news/create', [App\Http\Controllers\NewsController::class, 'Create'])->name('news.create');

Route::get('/news/{newsID}/edit', [App\Http\Controllers\NewsController::class, 'Edit'])->name('news.edit');

Route::post('/news/{newsID}/edit/update', [App\Http\Controllers\NewsController::class, 'Update'])->name('news.update');

Route::post('/news/create/save', [App\Http\Controllers\NewsController::class, 'Save'])->name('news.save');

Route::get('/news/{newsID}/deleted', [App\Http\Controllers\NewsController::class, 'Delete'])->name('news.delete');

Route::post('/upload-image', [App\Http\Controllers\NewsController::class, 'EditorUpload'])->name('upload.editor');

Route::post('/news/upload', [App\Http\Controllers\NewsController::class, 'upload'])->name('news.upload');
Route::post('/news/upload/category', [App\Http\Controllers\NewsController::class, 'uploadCategory'])->name('news.upload.category');
Route::post('/news/upload/headline', [App\Http\Controllers\NewsController::class, 'uploadHeadline'])->name('news.upload.headline');
Route::post('/news/upload/newsheadline', [App\Http\Controllers\NewsController::class, 'uploadnewsHeadline'])->name('news.upload.newsheadline');

Route::get('/news/order/mainheadline', [App\Http\Controllers\NewsController::class, 'IndexMainHeadline'])->name('news.mainheadline.index');
Route::get('/news/order/headline', [App\Http\Controllers\NewsController::class, 'IndexHeadLine'])->name('news.headline.index');

Route::post('/news/order/mainheadline/update', [App\Http\Controllers\NewsController::class, 'UpdateMainHeadline'])->name('news.mainheadline.update');
Route::post('/news/order/headline/update', [App\Http\Controllers\NewsController::class, 'UpdateHeadLine'])->name('news.headline.update');


Route::get('/videos/list', [App\Http\Controllers\VideoController::class, 'Index'])->name('video.index');

Route::get('/videos/create', [App\Http\Controllers\VideoController::class, 'Create'])->name('video.create');

Route::get('/videos/{videoID}/edit', [App\Http\Controllers\VideoController::class, 'Edit'])->name('video.edit');

Route::post('/videos/{videoID}/edit/update', [App\Http\Controllers\VideoController::class, 'Update'])->name('video.update');

Route::post('/videos/create/save', [App\Http\Controllers\VideoController::class, 'Save'])->name('video.save');

Route::get('/videos/{videoID}/deleted', [App\Http\Controllers\VideoController::class, 'Delete'])->name('video.delete');


Route::get('/official_news/list', [App\Http\Controllers\OfficialNewsController::class, 'Index'])->name('official.index');

Route::get('/official_news/create', [App\Http\Controllers\OfficialNewsController::class, 'Create'])->name('official.create');

Route::get('/official_news/{newsID}/edit', [App\Http\Controllers\OfficialNewsController::class, 'Edit'])->name('official.edit');

Route::post('/official_news/{newsID}/edit/update', [App\Http\Controllers\OfficialNewsController::class, 'Update'])->name('official.update');

Route::post('/official_news/create/save', [App\Http\Controllers\OfficialNewsController::class, 'Save'])->name('official.save');

Route::get('/official_news/{newsID}/deleted', [App\Http\Controllers\OfficialNewsController::class, 'Delete'])->name('official.delete');

Route::post('/get-ilan', [App\Http\Controllers\OfficialNewsController::class, 'GetOfficial'])->name('get.official.no');



Route::get('/photo-gallery/list', [App\Http\Controllers\PhotoGalleryController::class, 'Index'])->name('photogallery.index');

Route::get('/photo-gallery/create', [App\Http\Controllers\PhotoGalleryController::class, 'Create'])->name('photogallery.create');

Route::get('/photo-gallery/{galleryID}/edit', [App\Http\Controllers\PhotoGalleryController::class, 'Edit'])->name('photogallery.edit');

Route::post('/photo-gallery/{galleryID}/edit/update', [App\Http\Controllers\PhotoGalleryController::class, 'Update'])->name('photogallery.update');

Route::post('/photo-gallery/create/save', [App\Http\Controllers\PhotoGalleryController::class, 'Save'])->name('photogallery.save');

Route::get('/photo-gallery/{galleryID}/deleted', [App\Http\Controllers\PhotoGalleryController::class, 'Delete'])->name('photogallery.delete');

Route::get('/photo-gallery-image/{imageID}/deleted', [App\Http\Controllers\PhotoGalleryController::class, 'imageDelete'])->name('photogallery.image.delete');


Route::get('/analytics/referers', [App\Http\Controllers\GoogleReportController::class, 'getReferers']);
Route::get('/oauth2callback', [App\Http\Controllers\GoogleReportController::class, 'getReferers']);



Route::post('/get-ai-title', [App\Http\Controllers\NewsController::class, 'getAITitle'])->name('get.ai.title');
Route::post('/get-ai-tag', [App\Http\Controllers\NewsController::class, 'getAITag'])->name('get.ai.tag');
Route::post('/get-ai-content', [App\Http\Controllers\NewsController::class, 'getAIContent'])->name('get.ai.editor');
Route::post('/get-ai-warning', [App\Http\Controllers\NewsController::class, 'getAIWarning'])->name('get.ai.warning');

Route::any('/sent-notification/{newsID}', [App\Http\Controllers\NewsController::class, 'sentNotification'])->name('sent.notification');


Route::get('logout', [App\Http\Controllers\Auth\LoginController::class , 'logout']);



Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

});

