@extends('layouts.master')



@section('title','Anasayfa - Dashboard')



@section('content')



        <!-- ========== App Menu ========== -->

      

        <!-- ============================================================== -->

        <!-- Start right Content here -->

        <!-- ============================================================== -->

        <div class="main-content">



            <div class="page-content">

                <div class="container-fluid">



                    <!-- start page title -->

                    <div class="row">

                        <div class="col-12">

                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                                <h4 class="mb-sm-0">Raporlar & Grafikler</h4>



                                <div class="page-title-right">

                                    <ol class="breadcrumb m-0">

                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>

                                        <li class="breadcrumb-item active">Raporlar & Grafikler</li>

                                    </ol>

                                </div>



                            </div>

                        </div>

                    </div>

                    <!-- end page title -->



                    <div class="row">

                        <div class="col">



                            <div class="h-100">

                                <div class="row mb-3 pb-1">

                                    <div class="col-12">

                                        <div class="d-flex align-items-lg-center flex-lg-row flex-column">

                                            <div class="flex-grow-1">

                                                <h4 class="fs-16 mb-1">Günaydın!</h4>

                                                <p class="text-muted mb-0">Bugün Sistemde Neler Oluyor ?</p>

                                            </div>

                                       

                                        </div><!-- end card header -->

                                    </div>

                                    <!--end col-->

                                </div>

                                <!--end row-->



                                <div class="row">

                                    <div class="col-xl-3 col-md-6">

                                        <!-- card -->

                                        <div class="card card-animate">

                                            <div class="card-body">

                                                <div class="d-flex align-items-center">

                                                    <div class="flex-grow-1 overflow-hidden">

                                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Toplam Haber Sayısı</p>

                                                    </div>

                                                       <div class="flex-shrink-0">

                                                        <h5 class="text-muted fs-14 mb-0">

                                                            +0.00 %

                                                        </h5>

                                                    </div>

                                                </div>

                                                <div class="d-flex align-items-end justify-content-between mt-4">

                                                    <div>

                                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value" data-target="{{getNewsCount()}}">{{getNewsCount()}}</span> </h4>

                                                        <a href="/news/list" class="text-decoration-underline">Haberler</a>

                                                    </div>

                                                    <div class="avatar-sm flex-shrink-0">

                                                        <span class="avatar-title bg-primary-subtle rounded fs-3">

                                                            <i class="bx bx-user text-primary"></i>

                                                        </span>

                                                    </div>

                                                </div>

                                            </div><!-- end card body -->

                                        </div><!-- end card -->

                                    </div><!-- end col -->



                                    <div class="col-xl-3 col-md-6">

                                        <!-- card -->

                                        <div class="card card-animate">

                                            <div class="card-body">

                                                <div class="d-flex align-items-center">

                                                    <div class="flex-grow-1 overflow-hidden">

                                                     <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Toplam Köşe Yazısı</p>

                                                    </div>

                                                       <div class="flex-shrink-0">

                                                        <h5 class="text-muted fs-14 mb-0">

                                                            +0.00 %

                                                        </h5>

                                                    </div>

                                                </div>

                                                <div class="d-flex align-items-end justify-content-between mt-4">

                                                    <div>

                                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value" data-target="{{getNewsCornerCount()}}">{{getNewsCornerCount()}}</span></h4>

                                                        <a href="/news/list" class="text-decoration-underline">Köşe Yazıları</a>

                                                    </div>

                                                    <div class="avatar-sm flex-shrink-0">

                                                        <span class="avatar-title bg-primary-subtle rounded fs-3">

                                                            <i class="bx bx-shopping-bag text-primary"></i>

                                                        </span>

                                                    </div>

                                                </div>

                                            </div><!-- end card body -->

                                        </div><!-- end card -->

                                    </div><!-- end col -->



                                    <div class="col-xl-3 col-md-6">

                                        <!-- card -->

                                        <div class="card card-animate">

                                            <div class="card-body">

                                                <div class="d-flex align-items-center">

                                                    <div class="flex-grow-1 overflow-hidden">

                                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Toplam Foto Galeri Sayısı</p>

                                                    </div>

                                                   <div class="flex-shrink-0">

                                                        <h5 class="text-muted fs-14 mb-0">

                                                            +0.00 %

                                                        </h5>

                                                    </div>

                                                </div>

                                                <div class="d-flex align-items-end justify-content-between mt-4">

                                                    <div>

                                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value" data-target="{{getPhotoGalleryCount()}}">{{getPhotoGalleryCount()}}</span></h4>

                                                        <a href="/photo-gallery/list" class="text-decoration-underline">Foto Galeriler</a>

                                                    </div>

                                                    <div class="avatar-sm flex-shrink-0">

                                                        <span class="avatar-title bg-primary-subtle rounded fs-3">

                                                            <i class="bx bx-user-circle text-primary"></i>

                                                        </span>

                                                    </div>

                                                </div>

                                            </div><!-- end card body -->

                                        </div><!-- end card -->

                                    </div><!-- end col -->



                                    <div class="col-xl-3 col-md-6">

                                        <!-- card -->

                                        <div class="card card-animate">

                                            <div class="card-body">

                                                <div class="d-flex align-items-center">

                                                    <div class="flex-grow-1 overflow-hidden">

                                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Toplam Video Sayısı</p>

                                                    </div>

                                                    <div class="flex-shrink-0">

                                                        <h5 class="text-muted fs-14 mb-0">

                                                            +0.00 %

                                                        </h5>

                                                    </div>

                                                </div>

                                                <div class="d-flex align-items-end justify-content-between mt-4">

                                                    <div>

                                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value" data-target="{{getVideoGalleryCount()}}">{{getVideoGalleryCount()}}</span></h4>

                                                        <a href="{{ route('video.index') }}" class="text-decoration-underline">Videolar</a>

                                                    </div>

                                                    <div class="avatar-sm flex-shrink-0">

                                                        <span class="avatar-title bg-primary-subtle rounded fs-3">

                                                            <i class="bx bx-wallet text-primary"></i>

                                                        </span>

                                                    </div>

                                                </div>

                                            </div><!-- end card body -->

                                        </div><!-- end card -->

                                    </div><!-- end col -->

                                </div> <!-- end row-->  

                                <div class="row">
                        <div class="col-xl-12">
                            <div class="card crm-widget">
                                <div class="card-body p-0">
                                    <div class="row row-cols-xxl-4 row-cols-md-3 row-cols-1 g-0">
                                        <div class="col">
                                            <div class="py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bugün Toplam Kullanıcı</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-pulse-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value dayhit" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-md-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Dün Toplam Kullanıcı</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-pulse-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value yesterdayhit" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-md-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bu Hafta Toplam Kullanıcı</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-pulse-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value weekhit" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-lg-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bu Ay Toplam Kullanıcı</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-pulse-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value mounthhit" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- end row -->
                                </div><!-- end card body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                    </div>


                     <div class="row">
                        <div class="col-xl-12">
                            <div class="card crm-widget">
                                <div class="card-body p-0">
                                    <div class="row row-cols-xxl-4 row-cols-md-3 row-cols-1 g-0">
                                        <div class="col">
                                            <div class="py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bugün Sayfa Görüntüleme</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-space-ship-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value dayPageViews" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-md-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Dün Sayfa Görüntüleme</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-space-ship-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value yesterdayPageViews" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-md-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bu Hafta Sayfa Görüntüleme</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-space-ship-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value weekPageViews" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="mt-3 mt-lg-0 py-4 px-3">
                                                <h5 class="text-muted text-uppercase fs-13">Bu Ay Sayfa Görüntüleme</h5>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="ri-space-ship-line display-6 text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h2 class="mb-0"><span class="counter-value mounthPageViews" data-target="0">0</span></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- end row -->
                                </div><!-- end card body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                    </div>
                                <div class="row">
                                   <div class="col-xl-4">
                                    <div class="card card-height-100">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Ziyaret Eden Ülkeler</h4>
                                            <div>
                                                <button type="button" class="btn btn-soft-primary btn-sm">
                                                    Son 1 Ay
                                                </button>
                                                
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div>
                                                <div id="countries_charts" data-colors='["--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4", "--vz-primary-rgb, 0.4"]' class="apex-charts" dir="ltr"></div>
                                            </div>
                                        </div><!-- end card body -->
                                    </div><!-- end card -->
                                </div> <!-- end col-->
                                <div class="col-xl-4">
                                    <div class="card card-height-100">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Siteye Giren Cihazlar</h4>
                                            <div>
                                                <button type="button" class="btn btn-soft-primary btn-sm">
                                                    Son 1 Ay
                                                </button>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="user_device_pie_charts" data-colors='["--vz-primary", "--vz-primary-rgb, .75", "--vz-primary-rgb, 0.60"]' class="apex-charts" dir="ltr"></div>
                                            <div class="table-responsive mt-3">
                                                <table class="table table-borderless table-sm table-centered align-middle table-nowrap mb-0">
                                                    <tbody class="border-0" id="device-data-table">
                                                        <!-- Dinamik olarak doldurulacak -->
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    <div class="col-xl-4 col-md-6">
                                        <div class="card card-height-100">
                                            <div class="card-header align-items-center d-flex">
                                                <h4 class="card-title mb-0 flex-grow-1">Siteye Yönlendirmeler</h4>
                                                <div class="flex-shrink-0">
                                                    <button type="button" class="btn btn-soft-primary btn-sm">Son 1 Ay</button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row align-items-center">
                                                    <div class="col-6">
                                                        <h6 class="text-muted text-uppercase fw-semibold text-truncate fs-12 mb-3">Siteye Yönlendirmeler</h6>
                                                        <h4 class="mb-0 totalrefferer">0</h4> <!-- Toplam rakam buraya eklenecek -->
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="text-center">
                                                            <img src="assets/images/illustrator-1.png" class="img-fluid" alt="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mt-3 pt-2">
                                                    <div class="progress progress-lg rounded-pill"></div>
                                                </div>
                                                <div class="mt-3 pt-2 referrer">
                                                    <!-- Referrer Listesi -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                        <div class="col-xl-12 col-md-12">
                            <div class="card card-height-100">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Popüler Sayfalar</h4>
                                     <div>
                                                <button type="button" class="btn btn-soft-primary btn-sm">
                                                    Son 1 Ay
                                                </button>
                                                
                                            </div>
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table class="table align-middle table-borderless table-centered table-nowrap mb-0">
                                            <thead class="text-muted table-light">
                                                <tr>
                                                    <th scope="col">Sayfa Page</th>
                                                    <th scope="col">Kullanıcı</th>
                                                    <th scope="col">Yüzdelik Oranı</th>
                                                </tr>
                                            </thead>
                                            <tbody class="populartable">
                                                
                                                
                                            </tbody><!-- end tbody -->
                                        </table><!-- end table -->
                                    </div><!-- end -->
                                </div><!-- end cardbody -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                                    <!-- end col -->
                                </div>


                          

                                

                            </div> <!-- end .h-100-->



                        </div> <!-- end col -->

   <div class="col-auto layout-rightside-col">
                            <div class="overlay"></div>
                            <div class="layout-rightside">
                                <div class="card h-100 rounded-0 card-border-effect-none">
                                    <div class="card-body p-0">
                                        <div class="p-3">
                                            <h6 class="text-muted mb-0 text-uppercase fw-semibold">Son Eklenen Haberler</h6>
                                        </div>
                                        <div data-simplebar  class="p-3 pt-0">
                                            <div class="acitivity-timeline acitivity-main">
                                                
                                                @foreach($LastNews as $news)
                                                <div class="acitivity-item d-flex mt-3">
                                                    <div class="flex-shrink-0 avatar-xs acitivity-avatar">
                                                        <div class="avatar-title bg-success-subtle text-success rounded-circle">
                                                            <i class="ri-file-list-line"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h6 class="mb-1 lh-base"><a href="{{ route('news.edit', ['newsID' => $news->id]) }}">{{$news->name}}</a></h6>
                                                        <p class="text-muted mb-1">{{$news->short_description}}  @if($news->source_id==1) <span class="badge bg-warning-subtle text-warning">İha Haber Ajansı </span>@else <br /> <span class="badge bg-warning-subtle text-warning">{{$news->author->name ?? ''}} </span> @endif</p>
                                                        <small class="mb-0 text-muted">{{$news->date}} {{$news->time}}</small>
                                                    </div>
                                                </div>
                                                @endforeach
                                               
                                            </div>
                                        </div>

                                     

                                      
                                     
                                    </div>
                                </div> <!-- end card-->
                            </div> <!-- end .rightbar-->

                        </div> <!-- end col -->

                   

                    </div>



                </div>

                <!-- container-fluid -->

            </div>

            <!-- End Page-content -->



            <footer class="footer border-top">

                <div class="container-fluid">

                    <div class="row">

                        <div class="col-sm-6">

                            <script>document.write(new Date().getFullYear())</script> © {{'Haber<Code>'}}.

                        </div>

                        <div class="col-sm-6">

                            <div class="text-sm-end d-none d-sm-block">

                                Develop by Budun Technology

                            </div>

                        </div>

                    </div>

                </div>

            </footer>

        </div>

        <!-- end main content-->



    </div>

    <!-- END layout-wrapper -->





    <!--start back-to-top-->

 

@section('script')


<script type="text/javascript">

function getChartColorsArray(e) {
    if (null !== document.getElementById(e)) {
        var t = document.getElementById(e).getAttribute("data-colors");
        if (t) return (t = JSON.parse(t)).map(function(e) {
            var t = e.replace(" ", "");
            return -1 === t.indexOf(",") ? getComputedStyle(document.documentElement).getPropertyValue(t) || t : 2 == (e = e.split(",")).length ? "rgba(" + getComputedStyle(document.documentElement).getPropertyValue(e[0]) + "," + e[1] + ")" : t
        });
        console.warn("data-colors atributes not found on", e)
    }
}
var worldemapmarkers = "";

function loadCharts() {
    var e = getChartColorsArray("users-by-country");
    e && (document.getElementById("users-by-country").innerHTML = "", worldlinemap = "", worldlinemap = new jsVectorMap({
        map: "world_merc",
        selector: "#users-by-country",
        zoomOnScroll: !1,
        zoomButtons: !1,
        markers: [{
            name: "Greenland",
            coords: [72, -42]
        }, {
            name: "Canada",
            coords: [56.1304, -106.3468]
        }, {
            name: "Brazil",
            coords: [-14.235, -51.9253]
        }, {
            name: "Egypt",
            coords: [26.8206, 30.8025]
        }, {
            name: "Russia",
            coords: [61, 105]
        }, {
            name: "China",
            coords: [35.8617, 104.1954]
        }, {
            name: "United States",
            coords: [37.0902, -95.7129]
        }, {
            name: "Norway",
            coords: [60.472024, 8.468946]
        }, {
            name: "Ukraine",
            coords: [48.379433, 31.16558]
        }],
        lines: [{
            from: "Canada",
            to: "Egypt"
        }, {
            from: "Russia",
            to: "Egypt"
        }, {
            from: "Greenland",
            to: "Egypt"
        }, {
            from: "Brazil",
            to: "Egypt"
        }, {
            from: "United States",
            to: "Egypt"
        }, {
            from: "China",
            to: "Egypt"
        }, {
            from: "Norway",
            to: "Egypt"
        }, {
            from: "Ukraine",
            to: "Egypt"
        }],
        regionStyle: {
            initial: {
                stroke: "#9599ad",
                strokeWidth: .25,
                fill: e,
                fillOpacity: 1
            }
        },
        lineStyle: {
            animation: !0,
            strokeDasharray: "6 3 6"
        }
    }))
}
window.onresize = function() {
    setTimeout(() => {
        loadCharts()
    }, 0)
}, loadCharts();

var columnoptions, options, chart, chartHeatMapBasicColors = getChartColorsArray("audiences-sessions-country-charts"),
    chartAudienceColumnChartsColors = (chartHeatMapBasicColors && (options = {
        series: [{
            name: "Sat",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Fri",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Thu",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Wed",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Tue",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Mon",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }, {
            name: "Sun",
            data: generateData(18, {
                min: 0,
                max: 90
            })
        }],
        chart: {
            height: 400,
            type: "heatmap",
            offsetX: 0,
            offsetY: -8,
            toolbar: {
                show: !1
            }
        },
        plotOptions: {
            heatmap: {
                colorScale: {
                    ranges: [{
                        from: 0,
                        to: 50,
                        color: chartHeatMapBasicColors[0]
                    }, {
                        from: 51,
                        to: 100,
                        color: chartHeatMapBasicColors[1]
                    }]
                }
            }
        },
        dataLabels: {
            enabled: !1
        },
        legend: {
            show: !0,
            horizontalAlign: "center",
            offsetX: 0,
            offsetY: 20,
            markers: {
                width: 20,
                height: 6,
                radius: 2
            },
            itemMargin: {
                horizontal: 12,
                vertical: 0
            }
        },
        colors: chartHeatMapBasicColors,
        tooltip: {
            y: [{
                formatter: function(e) {
                    return void 0 !== e ? e.toFixed(0) + "k" : e
                }
            }]
        }
    }, (chart = new ApexCharts(document.querySelector("#audiences-sessions-country-charts"), options)).render()), getChartColorsArray("audiences_metrics_charts")),
    dountchartUserDeviceColors = (chartAudienceColumnChartsColors && (columnoptions = {
        series: [{
            name: "Last Year",
            data: [25.3, 12.5, 20.2, 18.5, 40.4, 25.4, 15.8, 22.3, 19.2, 25.3, 12.5, 20.2]
        }, {
            name: "Current Year",
            data: [36.2, 22.4, 38.2, 30.5, 26.4, 30.4, 20.2, 29.6, 10.9, 36.2, 22.4, 38.2]
        }],
        chart: {
            type: "bar",
            height: 309,
            stacked: !0,
            toolbar: {
                show: !1
            }
        },
        plotOptions: {
            bar: {
                horizontal: !1,
                columnWidth: "20%",
                borderRadius: 6
            }
        },
        dataLabels: {
            enabled: !1
        },
        legend: {
            show: !0,
            position: "bottom",
            horizontalAlign: "center",
            fontWeight: 400,
            fontSize: "8px",
            offsetX: 0,
            offsetY: 0,
            markers: {
                width: 9,
                height: 9,
                radius: 4
            }
        },
        stroke: {
            show: !0,
            width: 2,
            colors: ["transparent"]
        },
        grid: {
            show: !1
        },
        colors: chartAudienceColumnChartsColors,
        xaxis: {
            categories: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
            axisTicks: {
                show: !1
            },
            axisBorder: {
                show: !0,
                strokeDashArray: 1,
                height: 1,
                width: "100%",
                offsetX: 0,
                offsetY: 0
            }
        },
        yaxis: {
            show: !1
        },
        fill: {
            opacity: 1
        }
    }, (chart = new ApexCharts(document.querySelector("#audiences_metrics_charts"), columnoptions)).render()));



$(document).ready(function () {


    const today = new Date();
    const oneMonthAgo = new Date();
    oneMonthAgo.setMonth(today.getMonth() - 1); // Bir ay önceki tarihi hesapla

    const yesterday = new Date(today);
    yesterday.setDate(today.getDate() - 1); // Dün

    const weekStart = new Date(today);
    weekStart.setDate(today.getDate() - today.getDay()); // Haftanın ilk günü

    const monthStart = new Date(today);
    monthStart.setDate(1); // Ayın ilk günü


    // Tarih formatını yyyy-mm-dd olarak ayarla
    const formatDate = (date) => {
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0'); // Ayı 2 haneli hale getir
        const day = String(date.getDate()).padStart(2, '0'); // Günü 2 haneli hale getir
        return `${year}-${month}-${day}`;
    };


    // Tarih formatlama fonksiyonu
  

    // Laravel'den site_id'yi çek
    const siteId = "{{ env('SAYAC_SITE_ID') }}";

    // Dinamik URL
    const countryUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=country&from=${formatDate(oneMonthAgo)}&to=${formatDate(today)}&per_page=10`;
    const deviceUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=device&from=${formatDate(oneMonthAgo)}&to=${formatDate(today)}&per_page=10`;
    const referrerUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=referrer&from=${formatDate(oneMonthAgo)}&to=${formatDate(today)}&per_page=10`;
    const landing_pageUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=landing_page&from=${formatDate(oneMonthAgo)}&to=${formatDate(today)}&per_page=10`;
    const visitorsUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=visitors&from=${formatDate(monthStart)}&to=${formatDate(today)}&per_page=30`;
    const pageviewsUrl = `https://sayac.net.tr/api/v1/stats/${siteId}?name=pageviews&from=${formatDate(monthStart)}&to=${formatDate(today)}&per_page=30`;





    $.ajax({
        url: countryUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Ülkeler ve oturum sayıları
            const countries = data.map(item => item.value.split(":")[1]); // TR:Turkey -> Turkey
            const counts = data.map(item => parseInt(item.count));

            // Grafiği Güncelle
            updateChart(countries, counts);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });


         $.ajax({
        url: deviceUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Grafik için cihaz isimleri ve kullanıcı sayıları
            const labels = data.map(item => item.value.charAt(0).toUpperCase() + item.value.slice(1));
            const counts = data.map(item => parseInt(item.count));

            // Tabloyu doldur
            populateTable(data);

            // Grafiği güncelle
            updateChartdevice(labels, counts);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });


          $.ajax({
        url: referrerUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Toplam ve bar değerlerini hesapla
            const total = data.reduce((sum, item) => sum + parseInt(item.count), 0);

            // Toplam rakamı doldur
            updateTotal(total);

            // Barları ve referrer listesini doldur
            populateBars(data, total);
            populateReferrers(data, total);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });





             $.ajax({
        url:landing_pageUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Toplamı hesapla
            const total = response.total;

            // Tabloyu doldur
            populateTableLanding(data, total);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });



       $.ajax({
        url: visitorsUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Kullanıcı sayımlarını hesapla
            const todayCount = calculateTotal(data, formatDate(today));
            const yesterdayCount = calculateTotal(data, formatDate(yesterday));
            const weekCount = calculateRangeTotal(data, formatDate(weekStart), formatDate(today));
            const monthCount = calculateRangeTotal(data, formatDate(monthStart), formatDate(today));

            // HTML'yi güncelle
            updateCounts(todayCount, yesterdayCount, weekCount, monthCount);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });

         $.ajax({
        url: pageviewsUrl,
        method: "GET",
        headers: {
            "Accept": "application/json",
            "Authorization": "Bearer GApD0fzIefhniTuMHWsvBzm8OTB27NDILSbWyri2lsBjYqCY5t7HonfHDUA2ITau"
        },
        success: function (response) {
            const data = response.data;

            // Kullanıcı sayımlarını hesapla
            const todayCount = calculateTotal(data, formatDate(today));
            const yesterdayCount = calculateTotal(data, formatDate(yesterday));
            const weekCount = calculateRangeTotal(data, formatDate(weekStart), formatDate(today));
            const monthCount = calculateRangeTotal(data, formatDate(monthStart), formatDate(today));

            // HTML'yi güncelle
            updateCountsPageViews(todayCount, yesterdayCount, weekCount, monthCount);
        },
        error: function (error) {
            console.error("API hatası:", error);
        }
    });

});


function updateChart(countries, counts) {
    const options = {
        series: [{
            data: counts,
            name: "Sessions"
        }],
        chart: {
            type: "bar",
            height: 436,
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                borderRadius: 4,
                horizontal: true,
                distributed: true,
                dataLabels: {
                    position: "top"
                }
            }
        },
        colors: ["#bca5e5", "#33FF57", "#3357FF", "#57FF33", "#FF5733", "#57FF33", "#FF5733", "#FF5733", "#33FF57", "#3357FF"],
        dataLabels: {
            enabled: true,
            offsetX: 32,
            style: {
                fontSize: "12px",
                fontWeight: 900,
                colors: ["#adb5bd"]
            }
        },
        legend: {
            show: false
        },
        grid: {
            show: false
        },
        xaxis: {
            categories: countries
        }
    };

    // Chart initialize or update
    const chart = new ApexCharts(document.querySelector("#countries_charts"), options);
    chart.render();
}


function populateTable(data) {
    const tableBody = $("#device-data-table");
    tableBody.empty(); // Önceki verileri temizle

    // Renk sınıfları
    const colors = ["text-primary", "text-info", "text-warning", "text-success", "text-danger"];

    data.forEach((item, index) => {
        const label = item.value.charAt(0).toUpperCase() + item.value.slice(1);
        const count = parseInt(item.count).toLocaleString();

        // Sırasıyla renkleri atama
        const colorClass = colors[index % colors.length];

        const row = `
            <tr>
                <td>
                    <h4 class="text-truncate fs-14 fs-medium mb-0">
                        <i class="ri-stop-fill align-middle fs-18 ${colorClass} me-2"></i>${label}
                    </h4>
                </td>
                <td>
                    <p class="text-muted mb-0" style="    text-align: right;"><i data-feather="users" class="me-2 icon-sm"></i>${count}</p>
                </td>
            </tr>
        `;
        tableBody.append(row);
    });
}

    // Grafiği güncelle
    function updateChartdevice(labels, counts) {
        const options = {
            series: counts,
            labels: labels,
            chart: {
                type: "donut",
                height: 300
            },
            plotOptions: {
                pie: {
                    size: 100,
                    donut: {
                        size: "76%"
                    }
                }
            },
            dataLabels: {
                enabled: false
            },
            legend: {
                show: false
            },
            stroke: {
                width: 0
            },
            colors: ["#7758ae", "#3fa7d6", "#ffca5b", "#40bb82", "#ee6352"]
        };

        // Grafiği oluştur veya güncelle
        const chart = new ApexCharts(document.querySelector("#user_device_pie_charts"), options);
        chart.render();
    }

    function updateTotal(total) {
        $(".totalrefferer").text(total.toLocaleString()); // Toplam rakamı formatlayarak yerleştir
    }

    // Barları doldur
    function populateBars(data, total) {
        const progressBarContainer = $(".progress");
        progressBarContainer.empty(); // Önceki barları temizle

        // Renk sınıfları
        const colors = ["bg-primary", "bg-info", "bg-success", "bg-warning", "bg-danger"];

        data.forEach((item, index) => {
            const percentage = ((parseInt(item.count) / total) * 100).toFixed(2);
            const colorClass = colors[index % colors.length];

            const progressBarHTML = `
                <div class="progress-bar ${colorClass}" role="progressbar" style="width: ${percentage}%" aria-valuenow="${percentage}" aria-valuemin="0" aria-valuemax="100"></div>
            `;
            progressBarContainer.append(progressBarHTML);
        });
    }

    // Referrer'ları HTML'ye ekleme
    function populateReferrers(data, total) {
        const referrerContainer = $(".referrer"); // HTML'de container
        referrerContainer.empty(); // Önceki verileri temizle

        // Renk sınıfları
        const colors = ["text-primary", "text-info", "text-warning", "text-success", "text-danger", "text-secondary", "text-dark", "text-muted", "text-light", "text-white"];

        data.forEach((item, index) => {
            const url = item.value || "Diğer"; // Eğer value boşsa "Diğer" yaz
            const count = parseInt(item.count).toLocaleString();
            const percentage = ((item.count / total) * 100).toFixed(2);

            // Renk sınıfı sırayla atanır
            const colorClass = colors[index % colors.length];

            const referrerHTML = `
                <div class="d-flex mb-2">
                    <div class="flex-grow-1">
                        <p class="text-truncate text-muted fs-14 mb-0">
                            <i class="mdi mdi-circle align-middle ${colorClass} me-2"></i>${url}
                        </p>
                    </div>
                    <div class="flex-shrink-0">
                        <p class="mb-0">${percentage}%</p>
                    </div>
                </div>
            `;
            referrerContainer.append(referrerHTML);
        });
    }


     function populateTableLanding(data, total) {
        const tableBody = $(".populartable");
        tableBody.empty(); // Önceki verileri temizle

        data.forEach(item => {
            const page = item.value || "Ana Sayfa"; // Eğer value boşsa Ana Sayfa yaz
            const count = parseInt(item.count);
            const percentage = ((count / total) * 100).toFixed(2); // Yüzdelik hesaplama

            const rowHTML = `
                <tr>
                    <td>
                        <a href="javascript:void(0);">${page}</a>
                    </td>
                    <td>${count.toLocaleString()}</td>
                    <td>${percentage}%</td>
                </tr>
            `;
            tableBody.append(rowHTML);
        });
    }


    function calculateTotal(data, targetDate) {
        const record = data.find(item => item.value === targetDate);
        return record ? parseInt(record.count) : 0;
    }

    // Belirli bir tarih aralığı için toplam kullanıcı sayısını hesapla
    function calculateRangeTotal(data, startDate, endDate) {
        return data
            .filter(item => item.value >= startDate && item.value <= endDate)
            .reduce((sum, item) => sum + parseInt(item.count), 0);
    }

    // HTML'yi güncelle
    function updateCounts(today, yesterday, week, month) {
        // Bugün
        $(".dayhit").text(today.toLocaleString());

        // Dün
        $(".yesterdayhit").text(yesterday.toLocaleString());

        // Bu Hafta
        $(".weekhit").text(week.toLocaleString());

        // Bu Ay
        $(".mounthhit").text(month.toLocaleString());
    }

      function updateCountsPageViews(today, yesterday, week, month) {
        // Bugün
        $(".dayPageViews").text(today.toLocaleString());

        // Dün
        $(".yesterdayPageViews").text(yesterday.toLocaleString());

        // Bu Hafta
        $(".weekPageViews").text(week.toLocaleString());

        // Bu Ay
        $(".mounthPageViews").text(month.toLocaleString());
    }



</script>

@endsection




@endsection

