@extends('layouts.master')



@section('title','Foto Galeri')



@section('content')



   <!-- ============================================================== -->

   <div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Foto Galerileri Görüntüle</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Foto Galeriler</a></li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header">

                                    <h5 class="card-title mb-0" style="float: left;">Foto Galeriler</h5>

                                    <a href="{{ route('photogallery.create') }}" type="button" style="float:right;" class="btn btn-primary btn-sm" id="sa-basic">Yeni Foto Galeri Ekle</a>

                                </div>

                                <div class="card-body">

                                    <table id="newsList" class="table nowrap dt-responsive align-middle table-hover table-bordered" style="width:100%">

                                        <thead>

                                            <tr>

                                                <th>ID</th>

                                                <th>Foto Galeri Resmi </th>

                                                <th>Foto Galeri Adı </th>

                                                <th>Foto Galeri Kategori</th>

                                                <th>Foto Galeri Ziyaretci Sayısı</th>

                                                <th>Foto Galeri Zaman</th>

                                                <th>Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>



                                        @foreach($AllSound as $sound)

                                            <tr>

                                                <td>{{$sound->id ?? ''}}</td>

                                                <td>@if($sound->gallery_image!=NULL)

                                                    <img src="{{ env('SITE_URL') }}/uploads/images/news/{{ date("Y/m/d", strtotime($sound->date)) }}/{{$sound->gallery_image}}" style="width:50px; height: 50px;">

                                                    @else @endif

                                                </td>

                                                <td>{{$sound->name ?? ''}}</td>

                                                <td>{{$sound->category->name ?? ''}}</td>

                                                <td>0</td>

                                                <td>{{$sound->date ?? ''}} {{$sound->time ?? ''}}</td>

                                                <td>

                                                    <div class="dropdown d-inline-block">

                                                        <button class="btn btn-soft-primary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">

                                                            <i class="ri-more-fill align-middle"></i>

                                                        </button>

                                                        <ul class="dropdown-menu dropdown-menu-end">

                                                             <li><a href="{{ env('SITE_URL') }}foto-galeri/{{$sound->slug}}" target="_blank"  class="dropdown-item edit-item-btn"><i class="ri-eye-fill align-bottom me-2 text-muted"></i>Foto Galeriye Git</a></li>

                                                            <li><a href="{{ route('photogallery.edit', ['galleryID' => $sound->id]) }}"  class="dropdown-item edit-item-btn"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i>Foto Galeriye Düzenle</a></li>

                                                            <li><a href="{{ route('photogallery.delete', ['galleryID' => $sound->id]) }}"  class="dropdown-item edit-item-btn"><i class=" ri-delete-bin-fill align-bottom me-2 text-muted"></i>Foto Galeriyi Sil</a></li>

                                                            <li><a href="https://www.facebook.com/sharer/sharer.php?u={{ env('SITE_URL') }}/foto-galeri/{{$sound->slug}}"  target="_blank" class="dropdown-item edit-item-btn"><i class=" ri-facebook-circle-fill align-bottom me-2 text-muted"></i>Facebook'ta Paylaş</a></li>

                                                            <li><a href="https://twitter.com/intent/tweet?url={{ env('SITE_URL') }}/foto-galeri/{{$sound->slug}}&text={{$sound->name ?? ''}}" target="_blank"   class="dropdown-item edit-item-btn"><i class=" ri-twitter-fill align-bottom me-2 text-muted"></i>Twitter'da Paylaş</a></li>

                                                            <li><a href="https://api.whatsapp.com/send?text={{ env('SITE_URL') }}/foto-galeri/{{$sound->slug}}%20{{$sound->name ?? ''}}"  target="_blank" class="dropdown-item edit-item-btn"><i class=" ri-whatsapp-fill align-bottom me-2 text-muted"></i>Whatsapp'da Paylaş</a></li>

                                                            <li><a href="https://t.me/share/url?url={{ env('SITE_URL') }}/foto-galeri/{{$sound->slug}}&text={{$sound->name ?? ''}}"  target="_blank"  class="dropdown-item edit-item-btn"><i class="  ri-telegram-fill align-bottom me-2 text-muted"></i>Telegram'da Paylaş</a></li>

                                                            <li><a href="https://www.linkedin.com/shareArticle?mini=true&url={{ env('SITE_URL') }}/foto-galeri/{{$sound->slug}}"  target="_blank" class="dropdown-item edit-item-btn"><i class=" ri-linkedin-box-fill align-bottom me-2 text-muted"></i>Linkedin'de Paylaş</a></li>


                                                                                                                    </ul>

                                                    </div>

                                                </td>

                                            </tr>

                                            @endforeach

                                         

                                        </tbody>

                                    </table>

                                </div>

                            </div>

                        </div><!--end col-->

                    </div><!--end row-->



            </div>

        </div>

    </div>

  







  @section('style')    

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" />

    <!--datatable responsive css-->

    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />



    <style>

        .dropdown-item{

            cursor:pointer;

        }

      



           .colorBox {

                width: 15px;

                padding: 15px;

            }

    </style>



    @endsection

    @section('script')



    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>





    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>



    <script src="/assets/js/pages/datatables.init.js"></script>



    <script type="text/javascript">

        $(document).ready(function() {
            $('#newsList').DataTable({
                "order": [[0, 'desc']] // İlk sütunu (ID sütunu) büyükten küçüğe sırala
            });
        });


        function changeUserType(userID){

            $("#userID").val(userID);

        }



    </script>



    @endsection



@endsection

