@extends('layouts.master')



@section('title','Foto Galeriler - Foto Galeri Düzenle')



@section('content')


    <meta name="csrf-token" content="{{ csrf_token() }}">



<div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Foto Galeri Düzenle</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Anasayfa</a></li>

                                    <li class="breadcrumb-item"><a href="{{ route('photogallery.index') }}">Foto Galeri Görüntüle</a></li>

                                    <li class="breadcrumb-item active">Foto Galeri Düzenle</li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header align-items-center d-flex">

                                    <h4 class="card-title mb-0 flex-grow-1">Foto Galeri Bilgileri</h4>

                                   

                                </div><!-- end card header -->

                                <div class="card-body">

                                    <div class="live-preview">

                                        <form action="{{route('photogallery.update', ['galleryID' => $sound->id])}}" method="POST"  enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                                        <div class="row gy-4">

                                          <div class="col-xxl-12 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Foto Galeri Adı</label>

                                                    <input type="text" id="title"  name="name" value="{{$sound->name}}" required class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                            <!--end col-->

                                           

                                            <div class="col-xxl-12 col-md-6">

                                                <div>

                                                    <label for="valueInput" class="form-label">Foto Galeri Kısa Açıklama</label>

                                                    <textarea  name="short_description" rows="4"  class="form-control" id="basiInput">{{$sound->short_description}} </textarea>

                                                </div>

                                            </div>

                                             <div class="col-xxl-6 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Foto Galeri Etiketleri (Virgüllü Giriniz (Örn: Ankara,Haber,Katil))</label>

                                                    <input type="text"  name="tag " value="{{$sound->tag}}"  class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                              <div class="col-xxl-6 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Foto Galeri Slug (Seo Link)</label>

                                                    <input type="text"  id="seo-url"  name="slug" value="{{$sound->slug ?? ''}}"  class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                            <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Kategori Seç</label>

                                                        <select class="form-control" required  name="category_id"   name="category_id" >
                                                            <option value=""> Kategori Seç</option>
                                                            @foreach($TopCategories as $TopCategory)

                                                            <option value="{{$TopCategory->name}}" @if($TopCategory->id==$sound->category_id) selected @endif>{{$TopCategory->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                               


                                                  <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Foto Galeri Aktif Mi?</label>

                                                        <select class="form-control"  name="status" id="choices-single-default">

                                                            <option value="0" @if($sound->status==0) selected @endif>Pasif Foto Galeri (Taslak)</option>
                                                            <option value="1" @if($sound->status==1) selected @endif>Aktif Foto Galeri (Yayında)</option>

                                                        </select>

                                                    </div>

                                                </div>

                                            

                                            


                                            <div class="col-lg-12">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Foto Galeri Görseli</label>

                                                    <p class="text-muted">Foto Galeri Görseli</p>

                                                    <input class="form-control" name="file" id="formSizeDefault" type="file">

                                                </div>

                                            </div>
                                                <hr>

                                            
                                            <div class="row" id="selected-image-uploads">
<div class="table-responsive">
                                            <table class="table align-middle table-nowrap mb-0">
                                                 <button type="button" class="btn btn-secondary mb-3 col-md-3" style="margin-left: 10px; float:right; width:200px" id="add-more">Yeni Resim Ekle</button>

                                                <thead class="table-light">
                                                    <tr>
                                                        <th scope="col" style="width:160px">Resim</th>
                                                        <th scope="col">Açıklama</th>
                                                        <th scope="col">Sıra</th>
                                                        <th scope="col">Sil</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="new-images">


                                                                 @foreach($images as $image)
                                                    <tr>
                                                        <td><img src="{{ env('SITE_URL') }}/uploads/images/news/{{ date("Y/m/d", strtotime($sound->date)) }}/{{$image->image}}" style="height: 100px; width: 150px;object-fit: cover;"></td>
                                                        <td> <textarea class="form-control mb-2" name="selected-descriptions[{{$image->id}}]" >{{$image->short_description}}</textarea></td>
                                                        <td><input type="number" class="form-control mb-2" name="selected-codes[{{$image->id}}]" value="{{$image->code}}"  ></td>
                                                        <td class="text-success">    <a href="{{ route('photogallery.image.delete', ['imageID' => $image->id]) }}" type="submit" class="btn btn-danger btn-sm">Sil</a></td>
                                                   
                                                    </tr>
                                                 
                                              @endforeach
                                                               
                                                    <tr class="image-upload-tr">
                                                        <td> <input type="file" class="form-control mb-2" name="images[]" ></td>
                                                        <td> <textarea class="form-control mb-2" name="selected-descriptions[{{$image->id}}]" ></textarea></td>
                                                        <td><input type="number" class="form-control mb-2" name="selected-codes[{{$image->id}}]" value=""  ></td>
                                                        <td class="text-success">   </td>
                                                   
                                                    </tr>
                                                    
                                                </tbody>
                                              
                                            </table>
                                            <!-- end table -->
                                        </div>

                                            </div>

                                                <hr>

                                           


                                            
                                                <div style="clear:both;"></div>

                                                <div class="col-xxl-2 col-md-2">



                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;" >Foto Galeriyi Düzenle</button>

                                                </div>

                                                @if($error==1)

                                                <div style="z-index: 11">

                                                            <div id="borderedToast4" style="float:right" class="toast toast-border-danger overflow-hidden mt-3 fade show" role="alert" aria-live="assertive" aria-atomic="true">

                                                                <div class="toast-body">

                                                                    <div class="d-flex align-items-center">

                                                                        <div class="flex-shrink-0 me-2">

                                                                            <i class="ri-alert-line align-middle"></i>

                                                                        </div>

                                                                        <div class="flex-grow-1">

                                                                            <h6 class="mb-0">Bu Mail Adresi ya da Telefon Numarası Kullanılmaktadır.</h6>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                            </div>

                                                        </div>

                                                @endif

                                          

                                            <!--end col-->

                                            <!--end col-->

                                        </div>

                                        <!--end row-->

                                    </div>

                                    </form>

                                </div>

                            </div>

                        </div>

                        <!--end col-->

                    </div>

              

            </div>

        </div>

    </div>



       @section('style')   

       

           <link rel="stylesheet" href="/assets/libs/dropzone/dropzone.css" type="text/css" />

          



       @endsection

       



       @section('script')   

            <script src="/assets/libs/dropzone/dropzone-min.js"></script>



    <script src="/assets/js/pages/form-file-upload.init.js"></script>

     <script src="/assets/libs/filepond/filepond.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create( document.querySelector( '#editor' ),{
             ckfinder: {
              uploadUrl: '/upload-image?_token=' + document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
        } )
        .catch( error => {
            console.error( error );
        } );
</script>


  <script>
        $(document).ready(function() {
            $('#title').on('input', function() {
                var title = $(this).val();
                var seoUrl = generateSeoUrl(title);
                $('#seo-url').val(seoUrl);
            });

            function generateSeoUrl(title) {
                var trMap = {
                    'ç': 'c', 'Ç': 'C',
                    'ğ': 'g', 'Ğ': 'G',
                    'ı': 'i', 'I': 'I',
                    'İ': 'I', 'i': 'i',
                    'ö': 'o', 'Ö': 'O',
                    'ş': 's', 'Ş': 'S',
                    'ü': 'u', 'Ü': 'U'
                };
                return title.toLowerCase()
                    .replace(/[^a-z0-9\s-çğışöü]/gi, '') // Remove invalid characters
                    .replace(/[çğışöü]/g, function(match) { return trMap[match]; }) // Replace Turkish characters
                    .replace(/\s+/g, '-')         // Replace spaces with -
                    .replace(/-+/g, '-');         // Replace multiple - with single -
            }
        });
document.getElementById('add-more').addEventListener('click', function() {
        var newImageUpload = document.querySelector('.image-upload-tr').cloneNode(true);
        document.getElementById('new-images').appendChild(newImageUpload);
    });
    </script>
       @endsection





    @endsection





