@extends('layouts.master')



@section('title','Resmi İlanlar - Resmi İlan Ekleme')



@section('content')


    <meta name="csrf-token" content="{{ csrf_token() }}">



<div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Resmi İlan Ekleme</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Anasayfa</a></li>

                                    <li class="breadcrumb-item"><a href="{{ route('official.index') }}">Resmi İlanları Görüntüle</a></li>

                                    <li class="breadcrumb-item active">Resmi İlan Ekle</li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header align-items-center d-flex">

                                    <h4 class="card-title mb-0 flex-grow-1">Resmi İlan Bilgileri</h4>

                                   

                                </div><!-- end card header -->

                                <div class="card-body">

                                    <div class="live-preview">

                                        <form id="myForm" action="{{route('official.save')}}" method="POST"  enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                                        <div class="row gy-4">

                                         
                                           

                                                <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Resmi İlan Numarası</label>

                                                    <input type="text" required name="news_no" class="form-control" >

                                                </div>

                                            </div>

                                            <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Resmi İlan Adı</label>

                                                    <input type="text" id="title"  required name="title" class="form-control" id="basiInput">

                                                </div>

                                            </div>


                                            <!--end col-->

                                           

                                            <div class="col-xxl-12 col-md-12">

                                                <div>

                                                    <label for="valueInput" class="form-label">Resmi İlan Kısa Açıklama</label>

                                                   
                                                    <textarea  name="short_description" rows="4"  class="form-control" > </textarea>

                                                </div>

                                            </div>
                                                  <div class="col-lg-4">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Resmi İlan Görseli</label>

                                                    <p class="text-muted">Resmi İlan Görseli</p>

                                                    <input class="form-control" required name="file" id="formSizeDefault" type="file">

                                                </div>

                                            </div>

                                               <div class="col-xxl-4 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Resmi İlan Slug (Seo Link)</label>

                                                    <input type="text"  id="seo-url" required  name="slug" value="{{$sound->slug ?? ''}}"  class="form-control" id="basiInput">

                                                </div>

                                            </div>


                                       

                                              <div class="col-xxl-4 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Resmi İlan Tarihi</label>

                                                    <input type="datetime-local" required  name="date"  class="form-control" id="basiInput" >

                                                </div>

                                            </div>

                                            <div class="col-lg-12">

                                                <div>

                                                 <label for="formSizeDefault" class="form-label">Resmi İlan İçeriği</label>
                                              
                                                    <div style="clear:both;margin-top:10px;"></div>
                                                                  <textarea name="content" id="editor"></textarea>




                                                </div>

                                            </div>


                                            <div style="clear:both"></div>

                                          

                                                <div class="col-xxl-2 col-md-2">



                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;" >Resmi İlan Ekle</button>

                                                </div>

                                            </form>

                                                @if($error==1)

                                                <div style="z-index: 11">

                                                            <div id="borderedToast4" style="float:right" class="toast toast-border-danger overflow-hidden mt-3 fade show" role="alert" aria-live="assertive" aria-atomic="true">

                                                                <div class="toast-body">

                                                                    <div class="d-flex align-items-center">

                                                                        <div class="flex-shrink-0 me-2">

                                                                            <i class="ri-alert-line align-middle"></i>

                                                                        </div>

                                                                        <div class="flex-grow-1">

                                                                            <h6 class="mb-0">Bu Mail Adresi ya da Telefon Numarası Kullanılmaktadır.</h6>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                            </div>

                                                        </div>

                                                @endif

                                          

                                            <!--end col-->

                                            <!--end col-->

                                        </div>

                                        <!--end row-->

                                    </div>

                                 

                                </div>

                            </div>

                        </div>

                        <!--end col-->

                    </div>

                

            

            </div>

        </div>

    </div>



       @section('style')   

       

           <link rel="stylesheet" href="/assets/libs/dropzone/dropzone.css" type="text/css" />

          



       @endsection

       



       @section('script')   

            <script src="/assets/libs/dropzone/dropzone-min.js"></script>



    <script src="/assets/js/pages/form-file-upload.init.js"></script>

     <script src="/assets/libs/filepond/filepond.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>

    <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script src="https://cdn.tiny.cloud/1/b2mfx5d2fk0150gc62jevuah2jrkxqjm6k557wkgzb0g0kcc/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>



<script>

  const example_image_upload_handler = (blobInfo, progress) => new Promise((resolve, reject) => {
      const xhr = new XMLHttpRequest();
      xhr.withCredentials = false;
      xhr.open('POST', '/upload-image?_token=' + document.querySelector('meta[name="csrf-token"]').getAttribute('content'));

      xhr.upload.onprogress = (e) => {
        progress(e.loaded / e.total * 100);
      };

      xhr.onload = () => {
        if (xhr.status === 403) {
          reject({ message: 'HTTP Error: ' + xhr.status, remove: true });
          return;
        }

        if (xhr.status < 200 || xhr.status >= 300) {
          reject('HTTP Error: ' + xhr.status);
          return;
        }

        const json = JSON.parse(xhr.responseText);

        if (!json || typeof json.location != 'string') {
          reject('Invalid JSON: ' + xhr.responseText);
          return;
        }

        resolve(json.location);
      };

      xhr.onerror = () => {
        reject('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
      };

      const formData = new FormData();
      formData.append('file', blobInfo.blob(), blobInfo.filename());

      xhr.send(formData);
    });
  

  tinymce.init({
    selector: '#editor',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount linkchecker',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
    tinycomments_mode: 'embedded',
    language: 'tr', // Dil seçeneği burada belirtilir
    language_url: '/tr.js',
    tinycomments_author: 'Author name',
    mergetags_list: [
      { value: 'First.Name', title: 'First Name' },
      { value: 'Email', title: 'Email' },
    ],
        content_style: "body { font-size: 14pt; }",

    ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
    images_upload_handler: example_image_upload_handler
  });

</script>




  <script>
        $(document).ready(function() {
            $('#title').on('input', function() {
                var title = $(this).val();
                var seoUrl = generateSeoUrl(title);
                $('#seo-url').val(seoUrl);
            });

            function generateSeoUrl(title) {
                var trMap = {
                    'ç': 'c', 'Ç': 'C',
                    'ğ': 'g', 'Ğ': 'G',
                    'ı': 'i', 'I': 'I',
                    'İ': 'I', 'i': 'i',
                    'ö': 'o', 'Ö': 'O',
                    'ş': 's', 'Ş': 'S',
                    'ü': 'u', 'Ü': 'U'
                };
                return title.toLowerCase()
                    .replace(/[^a-z0-9\s-çğışöü]/gi, '') // Remove invalid characters
                    .replace(/[çğışöü]/g, function(match) { return trMap[match]; }) // Replace Turkish characters
                    .replace(/\s+/g, '-')         // Replace spaces with -
                    .replace(/-+/g, '-');         // Replace multiple - with single -
            }
        });
    </script>


    <script>
    $('#get_ilan').on('click', function() {


new PNotify({
                title: 'Başarılı',
                text: 'İlan.gov.tr Üzerinden ilan Getiriliyor ',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "İlan.gov.tr Üzerinden ilan Getiriliyor",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",
                                
            },
            onClick: function(){} // Callback after click
            }).showToast();

        var no = $('#no').val(); // Mevcut başlığı al

        // AJAX isteği gönder
        $.ajax({
            url: "{{ route('get.official.no') }}",
            type: "POST",
            data: {
                no: no
            },
             headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
            success: function(response) {
                // Gelen yeni başlığı input alanına yaz

                new PNotify({
                title: 'Başarılı',
                text: 'İlan.gov.tr Üzerinden ilan Getirildi',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "İlan.gov.tr Üzerinden ilan Getirildi",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",
                                
            },
            onClick: function(){} // Callback after click
            }).showToast();
                    alert(response);
                //$('#title').val(response);
            },
            error: function() {
                alert("Başlık oluşturulamadı. Lütfen tekrar deneyin.");
            }
        });
    });

     
    </script>
       @endsection





    @endsection
