@extends('layouts.master')



@section('title','Haberler')



@section('content')



   <!-- ============================================================== -->

   <div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Haberler Görüntüle</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Haberler</a></li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header">

                                    <h5 class="card-title mb-0" style="float: left;">Haberler</h5>

                                    <a href="{{ route('news.create') }}" type="button" style="float:right;" class="btn btn-primary btn-sm" id="sa-basic">Yeni Haber Ekle</a>

                                </div>

                                <div class="card-body">
                                     <form id="myForm" action="/news/list" method="GET"  enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <div class="row">
                                        
                                            <div class="col-xxl-3 col-md-3">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Adı</label>

                                                    <input type="text" id="name"   placeholder="Haber Adını Girebilirsiniz" name="name" class="form-control" id="basiInput">

                                                </div>

                                            </div>
                                             <div class="col-lg-3 col-md-3">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Kategori Seç</label>

                                                        <select class="form-control"  name="category_id"  id="category_id" >
                                                            <option value=""> Kategori Seç</option>
                                                            @foreach($TopCategories as $TopCategory)

                                                            <option value="{{$TopCategory->id}}">{{$TopCategory->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                                 <div class="col-lg-3 col-md-3">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Yazar Seç</label>

                                                        <select class="form-control"  name="author_id" id="author_id">
                                                            <option value=""> Yazar Seç</option>

                                                            @foreach($Authors as $Author)

                                                            <option value="{{$Author->id}}">{{$Author->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>
                                            <div class="col-xxl-2 col-md-2">



                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;margin-top:28px" >Filtreleme Yap</button>

                                                </div>

                                      </div>
                                  </form>
                                    

                                    <table id="newsList" class="table nowrap dt-responsive align-middle table-hover table-bordered" style="width:100%;margin-top:20px">

                                        <thead>

                                            <tr>

                                                <th>ID</th>

                                                <th>Haber Resmi </th>

                                                <th>Haber Adı </th>

                                                <th>Haber Yazarı</th>

                                                <th>Haber Kategori</th>

                                                <th>Haber Ziyaretci Sayısı</th>

                                                <th>Haber Zaman</th>

                                                <th>Haber Status</th>

                                                <th>Kaynak</th>

                                                <th>Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>



                                        @foreach($AllSound as $sound)

                                            <tr>

                                                <td>{{$sound->id ?? ''}}</td>

                                                <td>@if($sound->news_image!=NULL)

                                                    <img src="{{$sound->news_image}}" style="width:50px; height: 50px;">

                                                    @else @endif

                                                </td>

                                                <td>{{$sound->name ?? ''}}</td>

                                                <td>{{$sound->author->name ?? ''}}</td>

                                                <td>{{$sound->category->name ?? ''}}</td>

                                                <td>{{$sound->views_count ?? '0'}}</td>

                                                <td>{{$sound->date ?? ''}} {{$sound->time ?? ''}}</td>

                                                <td>@if($sound->status==1)<span class="badge bg-success-subtle text-success">@if($sound->status==1) Haber Aktif @else Haber Taslak @endif</span>@else <span class="badge bg-danger-subtle text-danger">@if($sound->status==1) Haber Aktif @else Haber Taslak @endif</span> @endif <br />

                                                    @if($sound->is_headline==1) <span class="badge bg-warning-subtle text-warning">Manşet Haber </span> <br />   @endif 

                                                    @if($sound->is_lastminute==1) <span class="badge bg-warning-subtle text-warning">Son Dakika Haber </span> <br /> @endif


                                                    @if($sound->is_breaking==1) <span class="badge bg-warning-subtle text-warning">Özel Haber </span> <br /> @endif

                                                      @if($sound->is_mainheadline==1) <span class="badge bg-warning-subtle text-warning">Sür Manşet Haber </span>  @endif

                                                      @if($sound->source_id==1) <span class="badge bg-warning-subtle text-warning">İha Haber Ajansı </span>  @endif

                                                </td>

                                                <td>
                                                    @if($sound->source_site == 'main_site')
                                                        <span class="badge bg-info-subtle text-info">Ana Site</span>
                                                        <br>
                                                        <small class="text-muted">{{ $sound->shared_at ? \Carbon\Carbon::parse($sound->shared_at)->format('d.m.Y H:i') : '' }}</small>
                                                    @else
                                                        <span class="badge bg-primary-subtle text-primary">Yerel</span>
                                                    @endif
                                                </td>

                                                <td>

                                                    <div class="dropdown d-inline-block">

                                                        <button class="btn btn-soft-primary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">

                                                            <i class="ri-more-fill align-middle"></i>

                                                        </button>

                                                        <ul class="dropdown-menu dropdown-menu-end">





                                                            <li><a href="{{ route('news.edit', ['newsID' => $sound->id]) }}"  class="dropdown-item edit-item-btn"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i>Haberi Düzenle</a></li>

                                                            <li><a href="{{ env('SITE_URL') }}{{$sound->slug}}.html" target="_blank" class="dropdown-item edit-item-btn"><i class="ri-eye-fill align-bottom me-2 text-muted"></i>Habere Git</a></li>

                                                            <li><a href="{{ route('sent.notification', ['newsID' => $sound->id]) }}"  class="dropdown-item edit-item-btn"><i class="ri-notification-fill align-bottom me-2 text-muted"></i>Bildirim Gönder</a></li>

                                                           <li><a href="{{ route('news.delete', ['newsID' => $sound->id]) }}"  class="dropdown-item edit-item-btn"><i class=" ri-delete-bin-fill align-bottom me-2 text-muted"></i>Haberi Sil</a></li> 

                                                            <li><a href="{{ route('news.index') }}?id={{$sound->id}}&type=1&change={{ $sound->status == 1 ? 0 : 1 }}" class="dropdown-item edit-item-btn"><i class=" ri-file-list-3-fill align-bottom me-2 text-muted"></i>@if($sound->status==1) Haber Taslak Yap @else  Haberi Yayınla @endif</a></li>
                                                            
                                                            <li><a href="{{ route('news.index') }}?id={{$sound->id}}&type=2&change={{ $sound->is_lastminute == 1 ? 0 : 1 }}" class="dropdown-item edit-item-btn"><i class=" ri-file-list-3-fill align-bottom me-2 text-muted"></i>@if($sound->is_lastminute==1) Haberi Son Dakika Haberden Kaldır @else  Haberi Son Dakikaya Ekle @endif</a></li>

                                                            <li><a href="{{ route('news.index') }}?id={{$sound->id}}&type=3&change={{ $sound->is_headline == 1 ? 0 : 1 }}" class="dropdown-item edit-item-btn"><i class=" ri-file-list-3-fill align-bottom me-2 text-muted"></i>@if($sound->is_headline==1) Haberi Manşet Haberden Kaldır @else  Haberi Manşet'e Ekle @endif</a></li>

                                                            <li><a href="{{ route('news.index') }}?id={{$sound->id}}&type=4&change={{ $sound->is_breaking == 1 ? 0 : 1 }}" class="dropdown-item edit-item-btn"><i class=" ri-file-list-3-fill align-bottom me-2 text-muted"></i>@if($sound->is_breaking==1) Haberi Özel Haberden Kaldır @else  Haberi Özel Haberi Ekle @endif</a></li>

                                                                                                                    </ul>

                                                    </div>

                                                </td>

                                            </tr>

                                            @endforeach

                                         

                                        </tbody>

                                    </table>

                                      <div class="d-flex justify-content-center">
                                        {!! $AllSound->links('vendor.custom_paginate')  !!}
                                    </div>

                                </div>

                            </div>

                        </div><!--end col-->

                    </div><!--end row-->



            </div>

        </div>

    </div>

  







  @section('style')    

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" />

    <!--datatable responsive css-->

    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />



    <style>

        .dropdown-item{

            cursor:pointer;

        }

      



           .colorBox {

                width: 15px;

                padding: 15px;

            }

    </style>



    @endsection

    @section('script')



    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>





    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>



    <script src="/assets/js/pages/datatables.init.js"></script>



    <script type="text/javascript">

       


        function changeUserType(userID){

            $("#userID").val(userID);

        }



    </script>



    @endsection



@endsection

